/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.boslayer.eas.framework.report.util.RptParams;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.BlobBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.bos.framework.core.util.Messages;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ksql.DbType;
import org.apache.log4j.Logger;

public class ExtDBUtil {
    private static final Logger log = Logger.getLogger(ExtDBUtil.class);

    public static final ResultSet executeQuery(Object ctx, String sql, String otherDataCenter) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDBPageSizeInfoBySQL");
        pr.setString("sql", sql);
        pr.setInt("start", 0);
        pr.setInt("rows", -1);
        pr.setString("outDB", otherDataCenter);
        RptParams psR = FacadeFactory.commonExecute(ctx, pr);
        return (ResultSet)psR.getObject("object");
    }

    public static List<Map<String, Object>> setDataToList(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>(10);
        ResultSetMetaData rsmd = rs.getMetaData();
        int len = rsmd.getColumnCount();
        while (rs.next()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(len);
            for (int i = 1; i <= len; ++i) {
                Object obj = rs.getObject(i);
                int type = rsmd.getColumnType(i);
                if (type == 2004) {
                    obj = BlobBO.readBlob(rs, i);
                }
                map.put(rsmd.getColumnName(i).toLowerCase(), obj);
            }
            lst.add(map);
        }
        return lst;
    }

    public static List<Map<String, String>> setDataToListForWeb(ResultSet rs) throws SQLException {
        ArrayList<Map<String, String>> lst = new ArrayList<Map<String, String>>(10);
        ResultSetMetaData rsmd = rs.getMetaData();
        int len = rsmd.getColumnCount();
        while (rs.next()) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(len);
            for (int i = 1; i <= len; ++i) {
                Object obj = rs.getObject(i);
                int type = rsmd.getColumnType(i);
                if (type == 2004) {
                    obj = BlobBO.readBlob(rs, i);
                }
                map.put(rsmd.getColumnName(i).toLowerCase(), CtrlReportUtil.getObjectString(obj));
            }
            lst.add(map);
        }
        return lst;
    }

    public static List<Object> getResultListBySql(Object ctx, String sql, List<Object> queryValue) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        RptParams psR = FacadeFactory.commonExecute(ctx, pr);
        return (List)psR.getObject("object");
    }

    public static Map getResultMapBySql(Object ctx, String sql, List queryValue) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoMapBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        RptParams psR = FacadeFactory.commonExecute(ctx, pr);
        return (Map)psR.getObject("object");
    }

    public static final int getDBType(Object ctx) {
        String dbTypeName = null;
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoFromServer");
        try {
            RptParams psR = FacadeFactory.commonExecute(ctx, pr);
            dbTypeName = psR.getString("dbTypeName");
        }
        catch (BOSException e) {
            log.warn((Object)e);
            return -1;
        }
        if (Messages.getMLS("externalDatabaseConnectionNotSet", "\u672a\u8bbe\u7f6e\u5916\u90e8\u6570\u636e\u5e93\u8fde\u63a5").equals(dbTypeName)) {
            return 4;
        }
        int bosDbtype = DbType.getValue((String)dbTypeName);
        switch (bosDbtype) {
            case 3: {
                return 3;
            }
            case 2: 
            case 7: 
            case 8: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 5: {
                return 5;
            }
            case 11: {
                return 11;
            }
            case 104: {
                return 104;
            }
        }
        return -1;
    }
}

