/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.model;

import com.kingdee.bos.corelayer.proxy.ISQLDesignerProxy;
import com.kingdee.bos.corelayer.proxy.ProxyFactory;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.extreport.utils.CloseUtil;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgRangeManage {
    private static final Logger log = LogUtil.getPackageLogger(OrgRangeManage.class);
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String PARENTID = "parentId";

    public static final DefObj[] getOrgRangeFieldList() {
        DefObj defItem1 = OrgRangeManage.getDefObj(ID, "ID");
        DefObj defItem2 = OrgRangeManage.getDefObj(NUMBER, Messages.getMLS("code", "\u7f16\u7801"));
        DefObj defItem3 = OrgRangeManage.getDefObj(NAME, Messages.getMLS(NAME, "\u540d\u79f0"));
        DefObj[] defObjs = new DefObj[]{defItem1, defItem2, defItem3};
        return defObjs;
    }

    public static final DefObj getDefObj(String name, String alias) {
        DefObj defItem = new DefObj(){

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getName()).append("  [").append(this.getAlias()).append("]");
                return sb.toString();
            }
        };
        defItem.setName(name);
        defItem.setAlias(alias);
        return defItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<Map<String, String>> getOrgRangeList(Object ctx) {
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        ISQLDesignerProxy sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy(ctx);
        ResultSet resultSet = sqlDesignerProxy.findUserOrgScopeInfo();
        try {
            while (resultSet.next()) {
                String orgID = resultSet.getString(1);
                String orgNumber = resultSet.getString(2);
                String orgName = resultSet.getString(3);
                String parentId = resultSet.getString(4);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(ID, CtrlReportUtil.getObjectString(orgID));
                map.put(NUMBER, CtrlReportUtil.getObjectString(orgNumber));
                map.put(NAME, CtrlReportUtil.getObjectString(orgName));
                map.put(PARENTID, CtrlReportUtil.getObjectString(parentId));
                dataList.add(map);
            }
            Comparator<Map<String, String>> mapCp = new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> oObj, Map<String, String> tObj) {
                    String oneNum = oObj.get(OrgRangeManage.NUMBER);
                    oneNum = StringUtil.isEmptyString((String)oneNum) ? "" : oneNum;
                    return oneNum.compareTo(tObj.get(OrgRangeManage.NUMBER));
                }
            };
            Collections.sort(dataList, mapCp);
        }
        catch (Exception e) {
            log.error((Object)Messages.getMLS("getUserOrganizationScopeError", "\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u8303\u56f4\u9519\u8bef"), (Throwable)e);
        }
        finally {
            CloseUtil.close(resultSet);
        }
        return dataList;
    }
}

