/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.xml;

import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureDataType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureIOType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.ProcedureParamData;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProcedureParameterIO {
    public static final String E_PROCEDURE = "Procedure";
    public static final String E_PARAMETER = "Parameter";
    public static final String A_NAME = "name";
    public static final String A_dbType = "dbType";
    public static final String A_resultNumber = "resultNumber";
    public static final String A_resultCursor = "resultCursor";
    public static final String A_bindFilterParamName = "bindFilterParamName";
    public static final String A_ioType = "ioType";
    public static final String A_dataType = "dataType";
    public static final String A_defaultValue = "defaultValue";

    public static final IXmlElement makeProcedure(ProcedureModel pm) {
        IXmlElement xml = XmlUtil.createNode((String)E_PROCEDURE);
        xml.setAttribute(A_NAME, pm.getName());
        xml.setAttribute(A_dbType, String.valueOf(pm.getDbType()));
        xml.setAttribute(A_resultNumber, String.valueOf(pm.getResultNumber()));
        xml.setAttribute(A_resultCursor, pm.getResultCursor());
        ArrayList paramList = pm.getParamList();
        if (paramList != null) {
            Iterator it = paramList.iterator();
            while (it.hasNext()) {
                xml.addChild(ProcedureParameterIO.makeProcedureParam((ProcedureParamData)((Object)it.next())));
            }
        }
        return xml;
    }

    private static final IXmlElement makeProcedureParam(ProcedureParamData ppd) {
        IXmlElement xml = XmlUtil.createNode((String)E_PARAMETER);
        if (ppd != null) {
            xml.setAttribute(A_NAME, CtrlReportUtil.getObjectString(ppd.getName()));
            xml.setAttribute(A_bindFilterParamName, CtrlReportUtil.getObjectString(ppd.getBindFilterParamName()));
            xml.setAttribute(A_ioType, String.valueOf(ppd.getIoType().intValue()));
            xml.setAttribute(A_dataType, String.valueOf(ppd.getDataType().intValue()));
            xml.setAttribute(A_defaultValue, CtrlReportUtil.getObjectString(ppd.getDefaultValue()));
        }
        return xml;
    }

    public static final ProcedureModel getProcedureModel(IXmlElement xml) {
        ProcedureModel pm = new ProcedureModel();
        pm.setName(CtrlReportUtil.getObjectString(xml.getAttribute(A_NAME)));
        pm.setDbType(Integer.parseInt(CtrlReportUtil.getObjectString(xml.getAttribute(A_dbType))));
        pm.setResultNumber(Integer.parseInt(CtrlReportUtil.getObjectString(xml.getAttribute(A_resultNumber))));
        pm.setResultCursor(CtrlReportUtil.getObjectString(xml.getAttribute(A_resultCursor)));
        ArrayList<ProcedureParamData> paramList = new ArrayList<ProcedureParamData>();
        List lst = xml.searchChildren(E_PARAMETER);
        Iterator i = lst.iterator();
        while (i.hasNext()) {
            ProcedureParamData p = ProcedureParameterIO.parseParameter((IXmlElement)i.next());
            paramList.add(p);
        }
        pm.setParamList(paramList);
        return pm;
    }

    private static ProcedureParamData parseParameter(IXmlElement xml) {
        ProcedureParamData ppd = new ProcedureParamData();
        ppd.setName(CtrlReportUtil.getObjectString(xml.getAttribute(A_NAME)));
        ppd.setBindFilterParamName(CtrlReportUtil.getObjectString(xml.getAttribute(A_bindFilterParamName)));
        ppd.setIoType(ProcedureIOType.getIOType(Integer.parseInt(CtrlReportUtil.getObjectString(xml.getAttribute(A_ioType)))));
        ppd.setDataType(ProcedureDataType.getDataTypee(Integer.parseInt(CtrlReportUtil.getObjectString(xml.getAttribute(A_dataType)))));
        ppd.setDefaultValue(CtrlReportUtil.getObjectString(xml.getAttribute(A_defaultValue)));
        return ppd;
    }
}

