/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.extreport.common.resultset;

import com.kingdee.bos.extreport.common.resultset.ResultSetFactory;
import com.kingdee.bos.extreport.common.resultset.ResultSetMetaDataStub;
import com.kingdee.bos.report.ds.vo.DesignerVO;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.List;

class ResultSetStub
implements InvocationHandler {
    private List<DesignerVO> delegate;
    private int rowIndex = 0;
    private ResultSetMetaData metaData;

    ResultSetStub() {
    }

    static ResultSet createStub(List<DesignerVO> delegate) {
        ResultSetStub handler = new ResultSetStub();
        handler.delegate = delegate;
        if (delegate.isEmpty()) {
            throw new RuntimeException("delegate can not be null,without metadata");
        }
        handler.metaData = ResultSetMetaDataStub.createStub(delegate.remove(0));
        return (ResultSet)Proxy.newProxyInstance(ResultSetFactory.class.getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().indexOf("next") != -1) {
            return this.rowIndex++ < this.delegate.size();
        }
        if (method.getName().indexOf("getMetaData") != -1) {
            return this.metaData;
        }
        if (method.getName().indexOf("getObject") != -1) {
            DesignerVO vo = this.delegate.get(this.rowIndex - 1);
            Object ret = vo.getFieldContent(this.metaData.getColumnLabel((Integer)args[0]));
            if (this.metaData.getColumnType((Integer)args[0]) != 3) {
                return ret;
            }
            if (ret != null) {
                return new BigDecimal(ret.toString());
            }
            return null;
        }
        if (method.getName().indexOf("close") != -1) {
            return null;
        }
        throw new Exception("unsurported method in ResultSetStub");
    }
}

