/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.extreport.formula;

import com.kingdee.bos.datawizard.edd.ctrlreport.util.fi.FIParam;
import com.kingdee.bos.extreport.common.model.formual.FormulaDef;
import com.kingdee.bos.extreport.common.model.formual.FormulaParam;
import com.kingdee.bos.extreport.common.model.formual.ParamType;
import com.kingdee.bos.extreport.formula.CommParamValueIntercepterFactory;
import com.kingdee.bos.extreport.formula.CommonParamValueIntercepter;
import com.kingdee.bos.extreport.utils.JsonUtil;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.IMethodBatchQuery;
import com.kingdee.cosmic.ctrl.kds.model.struct.Parameter;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedParameterArray;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractExtReportFunctionProvider
implements IMethodBatchQuery {
    private Map<String, FormulaDef> formulaDefMap = new HashMap<String, FormulaDef>();
    private String catalog;
    private ExecutionContext extCtx;
    private Map<String, String> commonParams = new HashMap<String, String>();
    private String jsonCommonParams;

    public void setExtCtx(ExecutionContext extCtx) {
        this.extCtx = extCtx;
    }

    public void setFiParams(List<FIParam> fiParams) {
        for (FIParam fiParam : fiParams) {
            String paramName = fiParam.getName();
            CommonParamValueIntercepter intercepter = CommParamValueIntercepterFactory.getValueIntercepter(paramName);
            if (intercepter != null) {
                this.commonParams.put(paramName, intercepter.intercept(fiParam.getValue()));
                continue;
            }
            this.commonParams.put(paramName, fiParam.getValue());
        }
        if (this.commonParams.size() > 0) {
            this.jsonCommonParams = JsonUtil.encodeToString(this.commonParams);
        }
    }

    protected String getJsonCommonParams() {
        return this.jsonCommonParams;
    }

    public ExecutionContext getExtCtx() {
        return this.extCtx;
    }

    public void setFormulaDefList(String catalog, List<FormulaDef> formulaDefList) {
        this.catalog = catalog;
        for (FormulaDef formulaDef : formulaDefList) {
            this.formulaDefMap.put(formulaDef.getNumber(), formulaDef);
        }
    }

    protected void logWarnMsg(String content) {
    }

    protected abstract void remoteBatchExecuteFormula(Map<String, String> var1, Map<String, Parameter> var2);

    public boolean batchQuery(Map map) {
        Iterator it = map.entrySet().iterator();
        HashMap<String, String> formulaExprMap = new HashMap<String, String>();
        HashMap<String, Parameter> sortedParamMap = new HashMap<String, Parameter>();
        int index = 1;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String method = (String)entry.getKey();
            SortedParameterArray param = (SortedParameterArray)entry.getValue();
            FormulaDef formulaDef = this.formulaDefMap.get(method);
            if (null == formulaDef) {
                this.logWarnMsg("invalid formula method:" + method + ", catalog:" + this.catalog);
                continue;
            }
            int paramSize = param.size();
            for (int i = 0; i < paramSize; ++i) {
                String formulaExpr = this.buildFormulaExpr(formulaDef, param.getParameter(i));
                if (null == formulaExpr) continue;
                formulaExprMap.put(String.valueOf(index), formulaExpr);
                sortedParamMap.put(String.valueOf(index), param.getParameter(i));
                ++index;
            }
            if (index % 100 != 0) continue;
            this.remoteBatchExecuteFormula(formulaExprMap, sortedParamMap);
            formulaExprMap.clear();
            sortedParamMap.clear();
        }
        if (!formulaExprMap.isEmpty()) {
            this.remoteBatchExecuteFormula(formulaExprMap, sortedParamMap);
        }
        return true;
    }

    private String buildFormulaExpr(FormulaDef formulaDef, Parameter innerParameter) {
        List<FormulaParam> fpList = formulaDef.getParam();
        if (fpList.size() != innerParameter.getArgs().length) {
            this.logWarnMsg("formula params size not consistent ,expr is invalid");
            return null;
        }
        StringBuilder formulaExprBuilder = new StringBuilder();
        formulaExprBuilder.append(formulaDef.getNumber());
        formulaExprBuilder.append("(");
        Object[] args = innerParameter.getArgs();
        for (int i = 0; i < fpList.size(); ++i) {
            FormulaParam fp = fpList.get(i);
            ParamType paramType = null;
            try {
                paramType = ParamType.valueOf(fp.getType());
                formulaExprBuilder.append(paramType.formatValue(args[i]));
            }
            catch (Exception e) {
                formulaExprBuilder.append("\"");
                formulaExprBuilder.append(args[i]);
                formulaExprBuilder.append("\"");
                this.logWarnMsg("invalid formula param type:" + fp.getType());
            }
            if (i >= fpList.size() - 1) continue;
            formulaExprBuilder.append(",");
        }
        formulaExprBuilder.append(")");
        return formulaExprBuilder.toString();
    }
}

