/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.launcher;

import com.kingdee.bos.app.launcher.Main;
import com.kingdee.bos.app.launcher.daemon.LauncherDaemon;
import com.kingdee.bos.app.launcher.daemon.multicast.MulticastListen;
import com.kingdee.bos.app.launcher.i18n.LangProviderProxy;
import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.launcher.useragent.UserAgent;
import com.kingdee.bos.app.launcher.useragent.manager.UserAgentManager;
import com.kingdee.bos.app.launcher.util.AppRootFolderUtil;
import com.kingdee.bos.app.launcher.util.COSMICLoginUtil;
import com.kingdee.bos.app.xlet.nativelib.NativeLibrary;
import com.kingdee.bos.app.xlet.util.exception.AppFrameworkException;
import com.kingdee.bos.app.xlet.util.exception.QingReportLicenseRuntimeException;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoExisitException;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataSetRejectExecException;
import com.kingdee.bos.extreport.common.strategy.ExtReportCustomStrategyRegistrar;
import com.kingdee.bos.extreport.common.strategy.ICustomStrategy;
import com.kingdee.bos.extreport.common.strategy.impl.GUISQLExtendReportStrategy;
import com.kingdee.bos.extreport.common.strategy.impl.ProxyFactoryImpl;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.cosmic.ctrl.common.CtrlUtil;
import com.kingdee.cosmic.ctrl.common.i18n.remote.ILangProviderProxy;
import com.kingdee.cosmic.ctrl.common.i18n.remote.LangProviderFactory;
import com.kingdee.cosmic.ctrl.swing.MessageDialog;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.cosmic.ctrl.swing.plaf.lfm.KDFontUIResource;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;

public class Launcher {
    private static final Logger LOGGER = Logger.getLogger(Launcher.class);
    private static Date aWeekAgo;
    private static final Runnable cleanCosmicLauncherFolderTask;

    /*
     * Exception decompiling
     */
    private static Pair<Boolean, Boolean> canDeleteFolder(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 22[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void launcher() throws Exception {
        Locale.setDefault(Locale.CHINA);
        ExtReportCustomStrategyRegistrar.register((ICustomStrategy)new ProxyFactoryImpl());
        ExtReportCustomStrategyRegistrar.register((ICustomStrategy)new GUISQLExtendReportStrategy());
        Launcher.initializeUncaughtExceptionHandler();
        Launcher.initLocale();
        try {
            KingdeeLookAndFeel.setCurrentTheme((int)3);
            UIManager.setLookAndFeel((LookAndFeel)new KingdeeLookAndFeel());
            Enumeration keys = UIManager.getDefaults().keys();
            while (keys.hasMoreElements()) {
                Object fontUIResource;
                Object key = keys.nextElement();
                Object value = UIManager.get(key);
                if (value instanceof KDFontUIResource) {
                    fontUIResource = (KDFontUIResource)value;
                    fontUIResource = new KDFontUIResource("\u5fae\u8f6f\u96c5\u9ed1", fontUIResource.getStyle(), fontUIResource.getSize());
                    UIManager.put(key, fontUIResource);
                    continue;
                }
                if (!(value instanceof FontUIResource)) continue;
                fontUIResource = (FontUIResource)value;
                fontUIResource = new FontUIResource("\u5fae\u8f6f\u96c5\u9ed1", ((Font)fontUIResource).getStyle(), ((Font)fontUIResource).getSize());
                UIManager.put(key, fontUIResource);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (CtrlUtil.isWinOS()) {
            NativeLibrary.initialize();
        }
        AppRootFolderUtil.clearClientAll("qs");
        Launcher.initialize();
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -7);
        aWeekAgo = calendar.getTime();
        new Thread(cleanCosmicLauncherFolderTask).start();
    }

    private static void initializeUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof AppFrameworkException && e.getCause() != null && (e.getCause() instanceof ExtDataSetNoExisitException || e.getCause() instanceof ExtDataSetNoPermissionException || e.getCause() instanceof ExtMacroException || e.getCause() instanceof DataCenterNoPermissionException)) {
                    MessageDialog.show((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), (Object)e.getMessage(), (String)QingRptLauncherMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (int)-1, (int)2, (String)Launcher.makeExceptionTrace(e));
                } else if (e instanceof AppFrameworkException && e.getCause() instanceof DataSetRejectExecException) {
                    DataSetRejectExecException cause = (DataSetRejectExecException)e.getCause();
                    String message = cause.getMessage();
                    MessageDialog.show((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), (Object)message, (String)QingRptLauncherMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (int)-1, (int)2, (String)Launcher.makeExceptionTrace(e));
                } else {
                    String msgbody = e.getCause() instanceof IOException || e.getCause() != null && e.getCause().getCause() instanceof IOException ? QingRptLauncherMessages.getMLS("errorAccessingServer", "\u8bbf\u95ee\u670d\u52a1\u5668\u8fc7\u7a0b\u51fa\u73b0\u9519\u8bef\uff1a\u7531\u4e8e\u7f51\u7edc\u95ee\u9898\u4e0d\u80fd\u6b63\u5e38\u8fde\u63a5\u5230\u670d\u52a1\u5668\u3002") : (e instanceof QingReportLicenseRuntimeException ? e.getMessage() : QingRptLauncherMessages.getMLS("unknownErrorOnClient", "\u5ba2\u6237\u7aef\u53d1\u751f\u4e86\u4e00\u4e2a\u672a\u77e5\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u7aef\u65e5\u5fd7\uff01"));
                    LOGGER.debug((Object)e.getMessage(), e);
                    MessageDialog.show((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), (Object)msgbody, (String)QingRptLauncherMessages.getMLS("errorOccurred", "\u53d1\u751f\u9519\u8bef"), (int)-1, (int)0, (String)Launcher.makeExceptionTrace(e));
                }
            }
        });
    }

    private static void initialize() throws IOException {
        System.setProperty("EAS_HOME", AppRootFolderUtil.filePathConcatenation(System.getProperty("java.io.tmpdir"), "cosmic-launcher-" + System.getProperty("jnlp.webVersion")) + File.separatorChar);
        MulticastListen multicastListen = new MulticastListen();
        multicastListen.setUniqueID(Main.LOCAL_SERVER_UUID);
        multicastListen.setDaemon(true);
        multicastListen.start();
        LauncherDaemon.polling();
    }

    private static void initLocale() {
        String webVersion = System.getProperty("jnlp.webVersion");
        String serverUrl = System.getProperty("jnlp.serverUrl");
        String userToken = System.getProperty("jnlp.token");
        LOGGER.info((Object)("Env webVersion: " + webVersion + "; USERTOKEN: " + userToken + "; SERVERURL: " + serverUrl));
        if (StringUtils.isNotBlank((CharSequence)userToken) && StringUtils.isNotBlank((CharSequence)serverUrl)) {
            COSMICLoginUtil.syncDefaultLocale(serverUrl, userToken);
            UserAgent userAgent = COSMICLoginUtil.getContext(serverUrl, userToken);
            if (userAgent != null) {
                LangProviderFactory.regist((ILangProviderProxy)new LangProviderProxy(userAgent));
                UserAgentManager.registerUserAgent(userAgent);
            }
        }
    }

    private static String makeExceptionTrace(Throwable e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        e.printStackTrace(ps);
        ps.close();
        return new String(out.toByteArray());
    }

    static {
        cleanCosmicLauncherFolderTask = new Runnable(){

            @Override
            public void run() {
                File tmpFolder = new File(System.getProperty("java.io.tmpdir"));
                if (!tmpFolder.exists()) {
                    return;
                }
                File[] allCosmicLauncherFolders = tmpFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().startsWith("cosmic-launcher");
                    }
                });
                if (allCosmicLauncherFolders != null && allCosmicLauncherFolders.length > 0) {
                    for (File cosmicLauncherFolder : allCosmicLauncherFolders) {
                        try {
                            long aWeekAgoTimestamp;
                            File logFile = new File(cosmicLauncherFolder.getCanonicalPath() + File.separator + "logs" + File.separatorChar + "cosmic_launcher_javaws.log");
                            if (logFile.exists()) {
                                long aWeekAgoTimestamp2;
                                Pair pair = Launcher.canDeleteFolder(logFile);
                                if (Boolean.TRUE.equals(pair.getLeft())) {
                                    if (!Boolean.TRUE.equals(pair.getRight())) continue;
                                    FileUtils.deleteDirectory((File)new File(cosmicLauncherFolder.getCanonicalPath() + File.separatorChar + "lib"));
                                    FileUtils.deleteDirectory((File)cosmicLauncherFolder);
                                    continue;
                                }
                                BasicFileAttributes attributes = Files.readAttributes(cosmicLauncherFolder.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                                long lastModifiedTimestamp = attributes.lastModifiedTime().to(TimeUnit.MILLISECONDS);
                                if (lastModifiedTimestamp >= (aWeekAgoTimestamp2 = aWeekAgo.getTime())) continue;
                                FileUtils.deleteDirectory((File)new File(cosmicLauncherFolder.getCanonicalPath() + File.separatorChar + "lib"));
                                FileUtils.deleteDirectory((File)cosmicLauncherFolder);
                                continue;
                            }
                            BasicFileAttributes attributes = Files.readAttributes(cosmicLauncherFolder.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                            long lastModifiedTimestamp = attributes.lastModifiedTime().to(TimeUnit.MILLISECONDS);
                            if (lastModifiedTimestamp >= (aWeekAgoTimestamp = aWeekAgo.getTime())) continue;
                            FileUtils.deleteDirectory((File)cosmicLauncherFolder);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
    }
}

