/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.launcher;

import com.kingdee.bos.app.launcher.daemon.LauncherDaemon;
import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.launcher.useragent.UserAgent;
import com.kingdee.bos.app.launcher.useragent.manager.UserAgentManager;
import com.kingdee.bos.app.launcher.useragent.manager.UserAgentManagerFrame;
import java.awt.AWTException;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LauncherSystemTray {
    private static final Logger LOGGER = Logger.getLogger(LauncherSystemTray.class);
    private static TrayIcon TRAY_ICON = null;

    private LauncherSystemTray() {
    }

    public static void initializeSystemTray() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            PopupMenu popup = new PopupMenu();
            ConsoleAction showConsole = new ConsoleAction();
            MenuItem menu = new MenuItem(QingRptLauncherMessages.getMLS("controlPanel", "\u63a7\u5236\u9762\u677f"));
            menu.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
            menu.addActionListener(showConsole);
            popup.add(menu);
            menu = new MenuItem(QingRptLauncherMessages.getMLS("exitBtn", "\u9000\u51fa"));
            menu.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
            menu.addActionListener(new ExitAction());
            popup.add(menu);
            String tooltip = QingRptLauncherMessages.getMLS("kingdeeCosmicQingReportTray", "\u91d1\u8776\u4e91\u82cd\u7a79\u8f7b\u62a5\u8868\u5957\u4ef6");
            String webVersion = System.getProperty("jnlp.webVersion");
            if (webVersion != null) {
                tooltip = tooltip + "\n" + QingRptLauncherMessages.getMLS("version", "\u7248\u672c\u53f7\uff1a") + webVersion;
            }
            TRAY_ICON = new TrayIcon(UserAgentManagerFrame.getGrayTrayLogo(), tooltip, popup);
            TRAY_ICON.addActionListener(showConsole);
            TRAY_ICON.setImageAutoSize(true);
            try {
                tray.add(TRAY_ICON);
                LOGGER.info((Object)"SystemTray registerred successfully!");
            }
            catch (AWTException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            LOGGER.warn((Object)"SystemTray not surpported on the current platform!");
        }
    }

    public static void setSystemTrayStatus(boolean active) {
        if (TRAY_ICON == null) {
            LauncherSystemTray.initializeSystemTray();
        }
        if (TRAY_ICON != null) {
            if (active) {
                TRAY_ICON.setImage(UserAgentManagerFrame.getTrayLogo());
            } else {
                TRAY_ICON.setImage(UserAgentManagerFrame.getGrayTrayLogo());
            }
        }
    }

    private static class ConsoleAction
    implements ActionListener {
        private ConsoleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserAgentManagerFrame.show();
        }
    }

    private static class ExitAction
    implements ActionListener {
        private ExitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LauncherDaemon.stopPolling();
            int userCount = UserAgentManager.getUserAgentCount();
            for (int i = 0; i < userCount; ++i) {
                UserAgent agent = UserAgentManager.queryUserAgent(i);
                if (agent == null) continue;
                UserAgentManager.exitAllXlets(agent);
                UserAgentManager.exitAgent(agent);
            }
            try {
                if (this.isWindows()) {
                    Runtime.getRuntime().exec("taskkill /F /IM jp2launcher.exe");
                }
            }
            catch (IOException exception) {
                LOGGER.error((Object)exception.getMessage(), (Throwable)exception);
            }
            System.exit(0);
        }

        public boolean isWindows() {
            return System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1;
        }
    }
}

