/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.launcher;

import com.kingdee.bos.app.launcher.daemon.VersionManagerDaemon;
import com.kingdee.bos.app.launcher.util.AppRootFolderUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl.LocalTempExtFile;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main {
    private static Logger LOGGER;
    private static String QS_HOME;
    public static String LOCAL_SERVER_UUID;

    private static void init() {
        LOGGER = Logger.getLogger(Main.class);
        QS_HOME = AppRootFolderUtil.filePathConcatenation(System.getProperty("java.io.tmpdir"), "cosmic-launcher-" + System.getProperty("jnlp.webVersion"), "qs");
        LOCAL_SERVER_UUID = UUID.randomUUID().toString();
        String logFileFolderPath = AppRootFolderUtil.filePathConcatenation(System.getProperty("java.io.tmpdir"), "cosmic-launcher-" + System.getProperty("jnlp.webVersion"), "logs") + File.separatorChar;
        File logFileFolder = new File(logFileFolderPath);
        if (!logFileFolder.exists()) {
            logFileFolder.mkdirs();
        }
        PropertyConfigurator.configure((URL)Main.class.getResource("log4j.properties"));
        VersionManagerDaemon.startVersionCheck();
    }

    public static void main(String[] args) throws Exception {
        if (args != null) {
            for (String arg : args) {
                String[] kv = arg.split("=");
                if (kv.length != 2) continue;
                System.setProperty(kv[0], kv[1]);
            }
        }
        Main.init();
        System.setProperty("sun.java2d.uiScale.enabled", "false");
        System.setProperty("sun.java2d.win.uiScaleX", "1.0");
        System.setProperty("sun.java2d.win.uiScaleY", "1.0");
        System.setProperty("ext.tempfile.impl", LocalTempExtFile.class.getName());
        System.setProperty("QingAnalysis.TempDir", QS_HOME);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String classLoaderName = cl.getClass().getName();
        LOGGER.info((Object)("ClassLoader Name: " + classLoaderName));
        String mainClassName = "com.kingdee.bos.app.launcher.Launcher";
        if (cl.getClass().getName().endsWith("JNLPClassLoader")) {
            mainClassName = "com.kingdee.bos.app.launcher.JNLPToLocalLauncher";
        }
        Class<?> mainClas = Class.forName(mainClassName);
        Method method = mainClas.getMethod("launcher", new Class[0]);
        method.invoke(null, (Object[])null);
    }
}

