/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.launcher.daemon;

import com.kingdee.bos.app.launcher.handler.CommandHandlerManager;
import com.kingdee.bos.app.launcher.useragent.UserAgent;
import com.kingdee.bos.app.launcher.useragent.manager.UserAgentManager;
import com.kingdee.bos.extreport.launcher.model.ExchangeMessage;
import java.net.SocketException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class LauncherDaemon {
    private static final Logger LOGGER = Logger.getLogger(LauncherDaemon.class);
    private static final ScheduledExecutorService pollingExecutorService = Executors.newSingleThreadScheduledExecutor();
    private static ScheduledFuture<?> scheduleFuture;

    public static void polling() {
        scheduleFuture = pollingExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                LauncherDaemon.executeTask(new Consumer<UserAgent>(){

                    @Override
                    public void accept(UserAgent agent) {
                        List<ExchangeMessage> messages = agent.getLauncherProxy().polling(agent.getUserToken());
                        for (ExchangeMessage message : messages) {
                            ExchangeMessage responseMessage = CommandHandlerManager.handle(message, agent);
                            if (responseMessage == null) continue;
                            String returnMessageString = responseMessage.packMessage();
                            agent.getLauncherProxy().sendResponse(agent.getUserToken(), responseMessage.clientId, returnMessageString);
                        }
                    }
                });
            }
        }, 1L, 3L, TimeUnit.SECONDS);
    }

    public static void stopPolling() {
        if (scheduleFuture != null) {
            scheduleFuture.cancel(true);
        }
    }

    private static void executeTask(Consumer<UserAgent> consumer) {
        UserAgent agent = null;
        try {
            int userCount = UserAgentManager.getUserAgentCount();
            for (int i = 0; i < userCount; ++i) {
                agent = UserAgentManager.queryUserAgent(i);
                if (agent == null) continue;
                consumer.accept(agent);
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalStateException && cause.getMessage() != null && cause.getMessage().contains("302")) {
                LOGGER.error((Object)("\u7528\u6237" + agent + " TOKEN\u8fc7\u671f\uff0cpolling\u8fdc\u7a0b\u8c03\u7528\u8fd4\u56de" + cause.getMessage()));
                LauncherDaemon.checkProxyCallExp(agent);
                return;
            }
            if (cause instanceof SocketException) {
                LOGGER.error((Object)("\u7528\u6237" + agent + "polling\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38\uff0c\u8fd4\u56de" + cause.getMessage()));
                return;
            }
            LOGGER.error((Object)"polling\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    private static void checkProxyCallExp(UserAgent agent) {
        int count;
        int n = count = agent != null ? agent.getProxyCallExpCount() : 0;
        if (count > 3) {
            UserAgentManager.deregisterUserAgent(agent);
        }
    }

    private static interface Consumer<T> {
        public void accept(T var1);
    }
}

