/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.launcher.daemon.multicast;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.app.launcher.daemon.multicast.AckMsg;
import com.kingdee.bos.app.launcher.daemon.multicast.Consumer;
import com.kingdee.bos.app.launcher.daemon.multicast.Msg;
import com.kingdee.bos.app.launcher.daemon.multicast.MsgType;
import com.kingdee.bos.app.launcher.daemon.multicast.NotifyMsg;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public abstract class Multicast
extends Thread {
    protected static final Logger LOGGER = Logger.getLogger(Multicast.class);
    private static final String MULTICAST_IP = "239.18.0.92";
    public static final int MULTICAST_PORT = 18092;
    private static final int DATA_LEN = 4096;
    private MulticastSocket multicastSocket = null;
    byte[] inBuff = new byte[4096];
    private DatagramPacket inPacket = null;
    private DatagramPacket outPacket = null;
    private InetAddress myInetAddress;
    private NetworkInterface myNetInterface;

    protected Multicast(String threadName) throws IOException {
        super(threadName);
        this.init();
    }

    public void init() throws IOException {
        this.initMyAddress();
        this.multicastSocket = new MulticastSocket(18092);
        if (this.myNetInterface != null) {
            this.multicastSocket.setNetworkInterface(this.myNetInterface);
        }
        InetAddress inetAddress = InetAddress.getByName(MULTICAST_IP);
        this.multicastSocket.joinGroup(inetAddress);
        this.multicastSocket.setLoopbackMode(false);
        this.inPacket = new DatagramPacket(this.inBuff, this.inBuff.length);
        this.outPacket = new DatagramPacket(new byte[0], 0, inetAddress, 18092);
    }

    protected void receive(Consumer<String, String> consumer) {
        boolean infiniteLoop = true;
        while (infiniteLoop) {
            try {
                this.multicastSocket.receive(this.inPacket);
                String receivedData = new String(this.inBuff, 0, this.inPacket.getLength());
                Msg receivedMsg = (Msg)JSON.parseObject((String)receivedData, Msg.class);
                if (MsgType.NOTIFY != receivedMsg.getType()) continue;
                String userName = System.getProperty("user.name");
                String myAddress = this.getLocalHostAddress();
                String fromAddress = receivedMsg.getFromAddress();
                LOGGER.info((Object)("receive\u63a5\u6536\u5230:" + (Object)((Object)receivedMsg.getType()) + ";From:" + receivedMsg.getFrom() + ";FromAddress:" + fromAddress + ";FromUserName:" + receivedMsg.getUserName() + ";Me:" + this.getUniqueID() + ";MyAddress:" + myAddress + ";MyUserName:" + userName));
                NotifyMsg notifyMsg = (NotifyMsg)JSON.parseObject((String)receivedData, NotifyMsg.class);
                if (this.getUniqueID().equals(notifyMsg.getFrom()) || myAddress == null || !myAddress.equals(fromAddress) || userName == null || !userName.equals(notifyMsg.getUserName())) continue;
                String ownWebVersion = System.getProperty("jnlp.webVersion");
                String webVersion = notifyMsg.getWebVersion();
                if (webVersion == null || !webVersion.equals(ownWebVersion)) continue;
                LOGGER.info((Object)("NewAddedEnv webVersion: " + webVersion + "; USERTOKEN: " + notifyMsg.getUserToken() + "; SERVERURL: " + notifyMsg.getServerUrl()));
                AckMsg ackMsg = new AckMsg();
                ackMsg.setType(MsgType.ACK);
                ackMsg.setFrom(this.getUniqueID());
                ackMsg.setFromAddress(myAddress);
                ackMsg.setUserName(userName);
                ackMsg.setTo(notifyMsg.getFrom());
                ackMsg.setToAddress(fromAddress);
                ackMsg.setSameVersion(true);
                String sendMsg = JSON.toJSONString((Object)ackMsg);
                byte[] buff = sendMsg.getBytes("utf-8");
                this.outPacket.setData(buff);
                this.multicastSocket.send(this.outPacket);
                consumer.accept(notifyMsg.getServerUrl(), notifyMsg.getUserToken());
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u591a\u64ad\u76d1\u542c\u5f02\u5e38", (Throwable)e);
                infiniteLoop = false;
            }
        }
    }

    protected abstract String getUniqueID();

    protected abstract void setUniqueID(String var1);

    @Override
    public abstract void run();

    protected void send(Msg msg) throws IOException {
        String sendMsg = JSON.toJSONString((Object)msg);
        this.outPacket.setData(sendMsg.getBytes("utf-8"));
        this.multicastSocket.send(this.outPacket);
        LOGGER.info((Object)("send\u53d1\u9001:" + (Object)((Object)msg.getType()) + ";From:" + msg.getFrom() + ";FromAddress:" + msg.getFromAddress() + ";Me:" + this.getUniqueID()));
        int waitTime = 3000;
        this.multicastSocket.setSoTimeout(waitTime);
        boolean findEnv = false;
        while (!findEnv) {
            boolean sameVersion;
            this.multicastSocket.receive(this.inPacket);
            String receivedData = new String(this.inBuff, 0, this.inPacket.getLength());
            Msg receivedMsg = (Msg)JSON.parseObject((String)receivedData, Msg.class);
            if (MsgType.ACK != receivedMsg.getType()) continue;
            String userName = System.getProperty("user.name");
            String myAddress = this.getLocalHostAddress();
            String fromAddress = receivedMsg.getFromAddress();
            LOGGER.info((Object)("send\u63a5\u6536\u5230:" + (Object)((Object)receivedMsg.getType()) + ";From:" + receivedMsg.getFrom() + ";FromAddress:" + fromAddress + ";FromUserName:" + receivedMsg.getUserName() + ";Me:" + this.getUniqueID() + ";MyAddress:" + myAddress + ";MyUserName:" + userName));
            AckMsg ackMsg = (AckMsg)JSON.parseObject((String)receivedData, AckMsg.class);
            if (!this.getUniqueID().equals(ackMsg.getTo()) || myAddress == null || !myAddress.equals(fromAddress) || userName == null || !userName.equals(ackMsg.getUserName()) || !(sameVersion = ackMsg.getSameVersion())) continue;
            findEnv = true;
        }
        LOGGER.info((Object)"\u627e\u5230\u4e00\u81f4\u8bbe\u8ba1\u5668\u73af\u5883\uff0c\u9000\u51fa\u672c\u6b21\u542f\u52a8\u6d41\u7a0b");
        System.exit(0);
    }

    protected String getLocalHostAddress() {
        if (this.myInetAddress == null) {
            this.initMyAddress();
        }
        return this.myInetAddress != null ? this.myInetAddress.getHostAddress() : null;
    }

    private void initMyAddress() {
        try {
            InetAddress loopbackAddress = null;
            NetworkInterface loopbackNetInterface = null;
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                InetAddress inetAddress = this.getInetAddress(networkInterface, false);
                if (inetAddress != null && inetAddress.isSiteLocalAddress()) {
                    this.myInetAddress = inetAddress;
                    this.myNetInterface = networkInterface;
                    return;
                }
                inetAddress = this.getInetAddress(networkInterface, true);
                if (inetAddress == null || loopbackAddress != null) continue;
                loopbackAddress = inetAddress;
                loopbackNetInterface = networkInterface;
            }
            this.myInetAddress = loopbackAddress;
            this.myNetInterface = loopbackNetInterface;
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u83b7\u53d6\u672c\u673aIP\u5730\u5740\u5f02\u5e38", (Throwable)e);
        }
    }

    private InetAddress getInetAddress(NetworkInterface networkInterface, boolean isLoopback) throws SocketException {
        if (networkInterface.isUp()) {
            InetAddress candidateIpV4 = null;
            InetAddress candidateIpV6 = null;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                boolean isLoopbackAddress = inetAddress.isLoopbackAddress();
                if (isLoopback && isLoopbackAddress) {
                    if (inetAddress.getAddress().length == 4) {
                        candidateIpV4 = inetAddress;
                        continue;
                    }
                    candidateIpV6 = inetAddress;
                    continue;
                }
                if (isLoopback || isLoopbackAddress) continue;
                if (inetAddress.getAddress().length == 4) {
                    candidateIpV4 = inetAddress;
                    continue;
                }
                candidateIpV6 = inetAddress;
            }
            return candidateIpV4 != null ? candidateIpV4 : candidateIpV6;
        }
        return null;
    }
}

