/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.launcher.useragent.manager;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.launcher.useragent.UserAgent;
import com.kingdee.bos.app.launcher.useragent.manager.UserAgentManager;
import com.kingdee.bos.app.xlet.IXlet;
import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.cosmic.ctrl.swing.KDContainer;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.cosmic.ctrl.workbench.ui.ImageButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.log4j.Logger;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import org.jdesktop.animation.transitions.Effect;
import org.jdesktop.animation.transitions.EffectsManager;
import org.jdesktop.animation.transitions.ScreenTransition;
import org.jdesktop.animation.transitions.TransitionTarget;
import org.jdesktop.animation.transitions.effects.CompositeEffect;
import org.jdesktop.animation.transitions.effects.FadeIn;
import org.jdesktop.animation.transitions.effects.FadeOut;

public class UserAgentControlPanel
extends KDPanel
implements TransitionTarget {
    private static final long serialVersionUID = -2219883819122992929L;
    private static final Logger LOGGER = Logger.getLogger(UserAgentControlPanel.class);
    private static Image LEFT_ARROW_IMAGE;
    private static Image RIGHT_ARROW_IMAGE;
    private CompositeEffect scrollToLeftIn = null;
    private CompositeEffect scrollToRightIn = null;
    private CompositeEffect scrollFadeOut = null;
    private Animator animator = new Animator(300);
    private ScreenTransition transition = new ScreenTransition((JComponent)((Object)this), (TransitionTarget)this, this.animator);
    private ControlBar controlbar;
    private DetailPanel detail;
    private boolean isScrollingToLeft;
    private int cursor;
    private UserAgent agent;

    public UserAgentControlPanel() {
        this.init();
        this.setSize(590, 390);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.controlbar = new ControlBar();
        this.detail = new DetailPanel();
        this.add((Component)((Object)this.controlbar), "North");
        this.add((Component)((Object)this.detail));
    }

    public void refresh() {
        this.agent = UserAgentManager.queryUserAgent(this.cursor);
        if (this.agent == null) {
            this.cursor = 0;
            this.agent = UserAgentManager.queryUserAgent(this.cursor);
            this.isScrollingToLeft = true;
            this.controlbar.refresh();
            this.transition.start();
            return;
        }
        this.controlbar.refresh();
        this.detail.refresh();
    }

    public void dispose() {
        this.agent = null;
        this.controlbar.refresh();
        this.detail.refresh();
    }

    public void setupNextScreen() {
        this.remove((Component)((Object)this.detail));
        EffectsManager.clearAllEffects();
        this.detail = new DetailPanel();
        this.detail.refresh();
        if (this.isScrollingToLeft) {
            EffectsManager.setEffect((JComponent)((Object)this.detail), (Effect)this.scrollToLeftIn, (EffectsManager.TransitionType)EffectsManager.TransitionType.APPEARING);
        } else {
            EffectsManager.setEffect((JComponent)((Object)this.detail), (Effect)this.scrollToRightIn, (EffectsManager.TransitionType)EffectsManager.TransitionType.APPEARING);
        }
        this.add((Component)((Object)this.detail));
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Move mover = new Move(width, 34);
        FadeIn fader = new FadeIn();
        this.scrollToLeftIn = new CompositeEffect((Effect)mover);
        this.scrollToLeftIn.addEffect((Effect)fader);
        mover = new Move(-width, 34);
        fader = new FadeIn();
        this.scrollToRightIn = new CompositeEffect((Effect)mover);
        this.scrollToRightIn.addEffect((Effect)fader);
        mover = new Move(0, 0);
        FadeOut fadeOut = new FadeOut();
        this.scrollFadeOut = new CompositeEffect((Effect)mover);
        this.scrollFadeOut.addEffect((Effect)fadeOut);
    }

    static {
        try {
            LEFT_ARROW_IMAGE = ImageIO.read(UserAgentControlPanel.class.getResource("left_arrow.png"));
            RIGHT_ARROW_IMAGE = ImageIO.read(UserAgentControlPanel.class.getResource("right_arrow.png"));
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static class Move
    extends Effect {
        private Point startLocation = new Point();
        private PropertySetter ps;

        public Move(int x, int y) {
            this.startLocation.x = x;
            this.startLocation.y = y;
            this.setRenderComponent(true);
        }

        public void init(Animator animator, Effect parentEffect) {
            Move targetEffect = parentEffect == null ? this : parentEffect;
            this.ps = new PropertySetter((Object)targetEffect, "location", (Object[])new Point[]{this.startLocation, new Point(this.getEnd().getX(), this.getEnd().getY())});
            animator.addTarget((TimingTarget)this.ps);
            super.init(animator, parentEffect);
        }

        public void cleanup(Animator animator) {
            animator.removeTarget((TimingTarget)this.ps);
        }
    }

    private class DetailPanel
    extends KDPanel {
        private static final long serialVersionUID = 4978023008283222372L;
        private KDTextField serviceGateway;
        private KDTextField userToken;
        private KDContainer connDetail;
        private KDLabelContainer labelCon;
        private KDContainer xletDetail;
        private KDTable table;

        private DetailPanel() {
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.serviceGateway = new KDTextField();
            this.userToken = new KDTextField();
            this.connDetail = new KDContainer();
            this.connDetail.setTitle(QingRptLauncherMessages.getMLS("userConnectionInfo", "\u7528\u6237\u8fde\u63a5\u4fe1\u606f"));
            KDPanel panel = new KDPanel();
            this.connDetail.setContentPane((Container)panel);
            panel.setLayout(null);
            panel.setPreferredSize(new Dimension(540, 40));
            this.labelCon = CtrlSwingUtilities.createLabelContainer((JComponent)this.serviceGateway, (String)QingRptLauncherMessages.getMLS("serviceAddress", "\u670d\u52a1\u5730\u5740 "), (int)80);
            panel.add((Component)this.labelCon);
            this.labelCon.setBounds(5, 5, 270, 20);
            this.labelCon.setBoundLabelLength(100);
            this.serviceGateway.setAccessAuthority(1);
            this.userToken.setAccessAuthority(1);
            this.xletDetail = new KDContainer();
            this.xletDetail.setTitle(QingRptLauncherMessages.getMLS("xletDetails", "Xlet\u8be6\u7ec6\u4fe1\u606f"));
            this.table = new KDTable();
            int colCount = 3;
            for (int i = 0; i < colCount; ++i) {
                IColumn column = this.table.addColumn(i);
                if (i == 2) continue;
                column.getStyleAttributes().setLocked(true);
            }
            this.table.getColumn(0).setWidth(120);
            this.table.getColumn(1).setWidth(280);
            this.table.getColumn(2).setWidth(100);
            EditorFactory.HyperLinkEditor linkeditor = (EditorFactory.HyperLinkEditor)this.table.getDefaultEditor(HyperLink.class);
            linkeditor.getLinkHandler().setExec("xlet:", new IHyperLinkExec(){

                public void execute(String linkTo) {
                    ((IXlet)DetailPanel.this.table.getRow(Integer.parseInt(linkTo)).getUserObject()).active();
                }
            });
            IRow row = this.table.addHeadRow();
            row.getCell(0).setValue((Object)QingRptLauncherMessages.getMLS("name", "\u540d\u79f0"));
            row.getCell(1).setValue((Object)QingRptLauncherMessages.getMLS("context", "\u4e0a\u4e0b\u6587"));
            row.getCell(2).setValue((Object)QingRptLauncherMessages.getMLS("operation", "\u64cd\u4f5c"));
            panel = new KDPanel();
            panel.setLayout((LayoutManager)new BorderLayout());
            panel.add((Component)this.table);
            this.xletDetail.setContentPane((Container)panel);
            this.connDetail.setEnableActive(false);
            this.xletDetail.setEnableActive(false);
            this.connDetail.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), this.connDetail.getBorder()));
            this.xletDetail.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), this.xletDetail.getBorder()));
            this.add((Component)this.connDetail, "North");
            this.add((Component)this.xletDetail);
        }

        private void refresh() {
            this.updateForLanguage();
            if (UserAgentControlPanel.this.agent == null) {
                this.serviceGateway.setText(null);
                this.userToken.setText(null);
                this.table.removeRows();
            } else {
                this.serviceGateway.setText(UserAgentControlPanel.this.agent.getServiceGateway());
                this.userToken.setText(UserAgentControlPanel.this.agent.getUserToken());
                this.table.removeRows();
                Object[] xlets = UserAgentControlPanel.this.agent.getXletManager().getAllXlets();
                for (int i = 0; i < xlets.length; ++i) {
                    IXlet xlet = (IXlet)xlets[i];
                    IRow row = this.table.addRow();
                    row.getCell(0).setValue((Object)xlet.getName());
                    row.getCell(1).setValue(xlet.getContext());
                    row.getCell(2).setValue((Object)new HyperLink(QingRptLauncherMessages.getMLS("popUpWindow", "\u5f39\u51fa\u7a97\u53e3"), "xlet:" + i));
                    row.setUserObject((Object)xlet);
                }
            }
        }

        private void updateForLanguage() {
            this.connDetail.setTitle(QingRptLauncherMessages.getMLS("userConnectionInfo", "\u7528\u6237\u8fde\u63a5\u4fe1\u606f"));
            this.labelCon.setBoundLabelText(QingRptLauncherMessages.getMLS("serviceAddress", "\u670d\u52a1\u5730\u5740 "));
            this.xletDetail.setTitle(QingRptLauncherMessages.getMLS("xletDetails", "Xlet\u8be6\u7ec6\u4fe1\u606f"));
            IRow row = this.table.getHeadRow(0);
            row.getCell(0).setValue((Object)QingRptLauncherMessages.getMLS("name", "\u540d\u79f0"));
            row.getCell(1).setValue((Object)QingRptLauncherMessages.getMLS("context", "\u4e0a\u4e0b\u6587"));
            row.getCell(2).setValue((Object)QingRptLauncherMessages.getMLS("operation", "\u64cd\u4f5c"));
        }
    }

    private class ControlBar
    extends KDPanel
    implements ActionListener {
        private static final long serialVersionUID = 667950273261321781L;
        private ImageButton left;
        private ImageButton right;
        private KDLabelContainer username;
        private KDWorkButton refresh;
        private KDWorkButton kickout;
        private KDTextField userfield;

        ControlBar() {
            this.init();
            this.initListeners();
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, 36);
        }

        private void init() {
            this.setLayout(null);
            this.left = new ImageButton(LEFT_ARROW_IMAGE);
            this.right = new ImageButton(RIGHT_ARROW_IMAGE);
            this.userfield = new KDTextField();
            this.userfield.setEnabled(false);
            this.username = CtrlSwingUtilities.createLabelContainer((JComponent)this.userfield, (String)QingRptLauncherMessages.getMLS("userCount", "\u7528\u6237 [?/0]"), (int)60);
            this.refresh = new KDWorkButton(QingRptLauncherMessages.getMLS("refresh", "\u5237\u65b0"));
            this.kickout = new KDWorkButton(QingRptLauncherMessages.getMLS("kickOutUser", "\u8e22\u51fa\u7528\u6237"));
            this.username.setBounds(45, 5, 140, 20);
            this.refresh.setBounds(195, 5, 60, 20);
            this.kickout.setBounds(265, 5, 90, 20);
            this.left.setBounds(0, 0, 35, 35);
            this.right.setBounds(548, 0, 35, 35);
            this.add((Component)this.left);
            this.add((Component)this.right);
            this.add((Component)this.username);
            this.add((Component)this.refresh);
            this.add((Component)this.kickout);
        }

        private void initListeners() {
            this.left.addActionListener((ActionListener)this);
            this.right.addActionListener((ActionListener)this);
            this.refresh.addActionListener((ActionListener)this);
            this.kickout.addActionListener((ActionListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.refresh) {
                UserAgentControlPanel.this.refresh();
                return;
            }
            if (e.getSource() == this.kickout) {
                UserAgentManager.deregisterUserAgent(UserAgentControlPanel.this.agent);
                UserAgentControlPanel.this.refresh();
                return;
            }
            int count = UserAgentManager.getUserAgentCount();
            if (e.getSource() == this.left) {
                UserAgentControlPanel.this.cursor--;
                if (UserAgentControlPanel.this.cursor < 0) {
                    UserAgentControlPanel.this.cursor = count - 1;
                }
                UserAgentControlPanel.this.isScrollingToLeft = true;
            } else {
                UserAgentControlPanel.this.cursor++;
                if (UserAgentControlPanel.this.cursor > count - 1) {
                    UserAgentControlPanel.this.cursor = 0;
                }
                UserAgentControlPanel.this.isScrollingToLeft = false;
            }
            UserAgentControlPanel.this.agent = UserAgentManager.queryUserAgent(UserAgentControlPanel.this.cursor);
            UserAgentControlPanel.this.controlbar.refresh();
            UserAgentControlPanel.this.transition.start();
        }

        private void refresh() {
            this.updateForLanguage();
            if (UserAgentControlPanel.this.agent == null) {
                this.userfield.setText(null);
                this.username.setBoundLabelText(QingRptLauncherMessages.getMLS("userCount", "\u7528\u6237 [?/0]"));
            } else {
                this.userfield.setText(UserAgentControlPanel.this.agent.getUserName());
                String str = QingRptLauncherMessages.getMLS("userInfo", "\u7528\u6237 [#1/#2]").replace("#1", String.valueOf(UserAgentControlPanel.this.cursor + 1)).replace("#2", String.valueOf(UserAgentManager.getUserAgentCount()));
                this.username.setBoundLabelText(str);
            }
        }

        private void updateForLanguage() {
            SwingUtilities.invokeLater(() -> {
                this.refresh.setText(QingRptLauncherMessages.getMLS("refresh", "\u5237\u65b0"));
                this.kickout.setText(QingRptLauncherMessages.getMLS("kickOutUser", "\u8e22\u51fa\u7528\u6237"));
            });
        }
    }
}

