/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.launcher.useragent.manager;

import com.kingdee.bos.app.launcher.LauncherSystemTray;
import com.kingdee.bos.app.launcher.useragent.UserAgent;
import com.kingdee.bos.app.launcher.useragent.util.UserAgentUtil;
import com.kingdee.bos.app.xlet.IXlet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class UserAgentManager {
    private static final Logger LOGGER = Logger.getLogger(UserAgentManager.class);
    private static final LinkedHashSet<UserAgent> ALL_USER_AGENT = new LinkedHashSet();

    public static synchronized UserAgent queryUserAgent(int index) {
        if (index > ALL_USER_AGENT.size() - 1 || index < 0) {
            return null;
        }
        UserAgent agent = null;
        Iterator uas = ALL_USER_AGENT.iterator();
        while (index >= 0) {
            agent = (UserAgent)uas.next();
            --index;
        }
        return agent;
    }

    public static synchronized UserAgent queryUserAgent(String serviceGateway, String usertoken) {
        Iterator agents = ALL_USER_AGENT.iterator();
        UserAgent agent = null;
        while (agents.hasNext()) {
            agent = (UserAgent)agents.next();
            if (!agent.getServiceGateway().equals(serviceGateway) || !agent.getUserToken().equals(usertoken)) continue;
            return agent;
        }
        return null;
    }

    public static synchronized void registerUserAgent(UserAgent agent) {
        LOGGER.info((Object)("\u6ce8\u518c\u65b0\u7528\u6237: " + agent));
        ALL_USER_AGENT.add(agent);
        UserAgentManager.refreshSystemTrayStatus();
    }

    public static void refreshSystemTrayStatus() {
        Iterator agents = ALL_USER_AGENT.iterator();
        boolean active = agents.hasNext();
        LauncherSystemTray.setSystemTrayStatus(active);
    }

    public static synchronized void deregisterUserAgent(UserAgent agent) {
        if (agent == null) {
            return;
        }
        LOGGER.info((Object)("\u6ce8\u9500\u7528\u6237: " + agent));
        ALL_USER_AGENT.remove(agent);
        UserAgentManager.exitAllXlets(agent);
        UserAgentManager.exitAgent(agent);
        UserAgentManager.refreshSystemTrayStatus();
        UserAgentUtil.gabageCollect();
    }

    public static void exitAllXlets(UserAgent agent) {
        Object[] xlets = agent.getXletManager().getAllXlets();
        if (xlets != null && xlets.length > 0) {
            for (int j = 0; j < xlets.length; ++j) {
                agent.getXletManager().quit((IXlet)xlets[j], true);
            }
        }
    }

    public static void exitAgent(UserAgent agent) {
        try {
            agent.getLauncherProxy().unregister(agent.getUserToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getUserAgentCount() {
        return ALL_USER_AGENT.size();
    }
}

