/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.launcher.util;

import java.io.File;
import org.apache.log4j.Logger;

public class AppRootFolderUtil {
    private static final Logger LOGGER = Logger.getLogger(AppRootFolderUtil.class);
    private static final String APP_ROOT_PATH = AppRootFolderUtil.filePathConcatenation(System.getProperty("java.io.tmpdir"), "cosmic-launcher-" + System.getProperty("jnlp.webVersion")) + File.separatorChar;

    private AppRootFolderUtil() {
    }

    public static String filePathConcatenation(String ... paths) {
        if (paths.length == 0) {
            return "";
        }
        if (paths.length == 1) {
            return paths[0] == null ? "" : paths[0];
        }
        File file = new File(paths[0], paths[1]);
        String finalPath = file.getAbsolutePath();
        for (int i = 2; i < paths.length; ++i) {
            file = new File(finalPath, paths[i]);
            finalPath = file.getAbsolutePath();
        }
        return finalPath;
    }

    public static void mkdirs(String relativePath) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(APP_ROOT_PATH);
        buffer.append(relativePath);
        String logFileFolderPath = buffer.toString();
        File logFileFolder = new File(logFileFolderPath);
        if (!logFileFolder.exists()) {
            logFileFolder.mkdirs();
        }
    }

    public static void clearClientAll(String dir) {
        File dirFile = new File(APP_ROOT_PATH + dir);
        AppRootFolderUtil.doDelFile(dirFile);
    }

    private static void doDelFile(File file) {
        if (file.exists()) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                for (File child : children) {
                    AppRootFolderUtil.doDelFile(child);
                }
            }
            try {
                file.delete();
            }
            catch (Exception e) {
                LOGGER.error((Object)("delete file error\uff1a" + e.getMessage()), (Throwable)e);
            }
        }
    }
}

