/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.proxy.facade;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.proxy.context.impl.RptDesignerContext;
import com.kingdee.bos.app.proxy.context.impl.RptExecutorContext;
import com.kingdee.bos.app.proxy.impl.rpt.ExtDataSetProxy;
import com.kingdee.bos.app.proxy.impl.rpt.TempleteIOProxy;
import com.kingdee.bos.app.proxy.impl.snap.SnapshotProxy;
import com.kingdee.bos.extreport.manage.model.ExtReportPermVO;
import com.kingdee.bos.extreport.manage.model.ExtReportVO;
import com.kingdee.bos.extreport.snap.model.ExtReportSnapSaveInfo;
import com.kingdee.bos.extreport.utils.JsonUtil;
import com.kingdee.bos.report.ext.service.po.ExtDataSetSegment;
import com.kingdee.bos.report.ext.service.po.ExtDataSetTransModel;
import com.kingdee.bos.report.ext.service.po.ExtParameterTransModel;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import java.util.HashMap;
import java.util.Map;

public class RptExecutorFacade {
    protected RptExecutorContext context;
    private TempleteIOProxy templeteIOProxy;
    private ExtDataSetProxy datasetProxy;
    private SnapshotProxy snapshotProxy;
    private String rptName;

    public RptExecutorFacade(RptExecutorContext context) {
        this.context = context;
    }

    public ExtDataSetTransModel fetchExtDataSetTransModel(int datasetType, String datasetAlias, String define, String meta, Map<String, ExtParameterTransModel> params) {
        if (this.context instanceof RptDesignerContext && params == null) {
            params = new HashMap<String, ExtParameterTransModel>();
        }
        return this.getExtDataSetProxy().fetchExtDataSetTransModel(this.context.getExtReportId(), datasetType, datasetAlias, define, meta, params, this.context.isPreview());
    }

    public ExtDataSetSegment fetchExtDataSetSegment(String tag) {
        return this.getExtDataSetProxy().fetchExtDataSetSegment(tag);
    }

    public byte[] fetchTempleteData() {
        return this.getTempleteIOProxy().fetchTempleteData(this.context.getExtReportId());
    }

    public byte[] fetchTempleteData(String uuid) {
        return this.getTempleteIOProxy().fetchTempleteData(uuid);
    }

    public byte[] fetchTemplateDataByProps(String sourceReportId, String targetReportId, String pathAlias) {
        return this.getTempleteIOProxy().fetchTemplateDataByProps(sourceReportId, targetReportId, pathAlias);
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean force) {
        if (this.rptName == null || force) {
            if (this.context.isSnapshot()) {
                throw new UnsupportedOperationException(QingRptLauncherMessages.getMLS("snapshotNotSupported", "\u6682\u65f6\u4e0d\u652f\u6301\u5feb\u7167"));
            }
            this.rptName = this.getTempleteIOProxy().fetchReportName(this.context.getExtReportId());
        }
        return this.rptName;
    }

    public String getExtReportId() {
        return this.context.getExtReportId();
    }

    public Map<String, IParameter> fetchSystemParameters() {
        return this.context.getSysParams();
    }

    public ExtReportVO findReportInfoByUuid(String reportUuid) {
        if (StringUtil.isEmptyString((String)reportUuid)) {
            return null;
        }
        return this.getTempleteIOProxy().findReportInfoByUuid(reportUuid);
    }

    public ExtReportPermVO findReportPermissions(String reportUuid) {
        if (StringUtil.isEmptyString((String)reportUuid)) {
            return null;
        }
        return this.getTempleteIOProxy().findReportPermissions(reportUuid);
    }

    public ReportProperties fetchReportProperties(String uuid) {
        if (StringUtil.isEmptyString((String)uuid)) {
            return null;
        }
        ExtReportVO meta = this.findReportInfoByUuid(uuid);
        if (meta == null) {
            return null;
        }
        String extreportGroupID = meta.getExtReportGroupID();
        ReportProperties properties = new ReportProperties(uuid, meta.getExtReportName(), extreportGroupID);
        ExtReportPermVO extReportPermVO = this.findReportPermissions(uuid);
        if (extReportPermVO != null) {
            properties.setPrintPermitted(extReportPermVO.isPrintPermitted());
            properties.setExportPermitted(extReportPermVO.isExportPermitted());
            properties.setSaveSnapshotPermitted(extReportPermVO.isSaveSnapshotPermitted());
            properties.setPublish(extReportPermVO.isPublished());
        }
        if (this.context.isPreview() || this.context.isIntegrate()) {
            properties.setExportPermitted(true);
            properties.setPrintPermitted(true);
            properties.setPreview(true);
            properties.setPublish(false);
            properties.setTipText(QingRptLauncherMessages.getMLS("previewDataOnlySomeThenPublish", "\u9884\u89c8\u6570\u636e\u4ec5\u53d6\u90e8\u5206\u6570\u636e\u8ba1\u7b97\uff0c\u53d1\u5e03\u62a5\u8868\u540e\u53ef\u67e5\u770b\u6b63\u786e\u7684\u7edf\u8ba1\u7ed3\u679c\u3002"));
        } else {
            properties.setPreview(false);
        }
        return properties;
    }

    public String findFormulaConfigs() {
        return this.getTempleteIOProxy().findFormulaConfigs();
    }

    public String batchExecuteFormulas(String jsonFormulaExpr, String jsonCommonParams) {
        return this.getTempleteIOProxy().batchExecuteFormulas(jsonFormulaExpr, jsonCommonParams);
    }

    public RptExecutorContext getContext() {
        return this.context;
    }

    protected TempleteIOProxy getTempleteIOProxy() {
        if (this.templeteIOProxy == null) {
            this.templeteIOProxy = new TempleteIOProxy(this.context.getUserAgent());
        }
        return this.templeteIOProxy;
    }

    private ExtDataSetProxy getExtDataSetProxy() {
        if (this.datasetProxy == null) {
            this.datasetProxy = new ExtDataSetProxy(this.context.getUserAgent());
        }
        return this.datasetProxy;
    }

    private SnapshotProxy getSnapshotProxy() {
        if (this.snapshotProxy == null) {
            this.snapshotProxy = new SnapshotProxy(this.context.getUserAgent());
        }
        return this.snapshotProxy;
    }

    public Object saveSnapshotCall(String method, Object[] params) {
        Object rtn = null;
        if ("addSnapshot".equals(method)) {
            String jsonStr = (String)params[0];
            ExtReportSnapSaveInfo snapSaveInfo = (ExtReportSnapSaveInfo)JsonUtil.decodeFromString((String)jsonStr, ExtReportSnapSaveInfo.class);
            snapSaveInfo.setCreatorId(this.context.getUserAgent().getUserID());
            this.getSnapshotProxy().addSnapshot(snapSaveInfo, (byte[])params[1]);
        } else if ("checkSnapNameExist".equals(method)) {
            rtn = this.getSnapshotProxy().checkSnapNameExist((String)params[0], (String)params[1], (String)params[2]);
        } else if ("loadSnapFolder".equals(method)) {
            rtn = this.getSnapshotProxy().loadSnapFolder((String)params[0], this.context.getUserAgent().getUserID());
            rtn = JsonUtil.encodeToString((Object)rtn);
        }
        return rtn;
    }
}

