/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.proxy.impl;

import com.kingdee.bos.app.proxy.HessianClient;
import com.kingdee.bos.app.proxy.context.impl.DSDesignerContext;
import com.kingdee.bos.extreport.common.resultset.ResultSetFactory;
import com.kingdee.bos.report.ds.dto.DesignerVOTransferModel;
import com.kingdee.bos.report.ds.dto.DesignerVOTransferSegment;
import com.kingdee.bos.report.ds.vo.DesignerVO;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtQSWriteFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IExtQSWriter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtMetaInfo;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BatchTransferUtil {
    private static final Logger logger = Logger.getLogger(BatchTransferUtil.class);

    private BatchTransferUtil() {
    }

    private static DesignerVOTransferSegment fetchTransferSegment(HessianClient client, DSDesignerContext context, String segmentTag) {
        DesignerVO param = new DesignerVO(0);
        param.addColumn("segmentTag", (Object)segmentTag);
        DesignerVOTransferSegment transferSegment = client.call(context.getUserAgent(), "fetchTransferSegment", DesignerVOTransferSegment.class, param);
        return transferSegment;
    }

    public static ResultSet createResultSetStub(DesignerVOTransferModel transferModel, HessianClient client, DSDesignerContext context, boolean isUpdate) {
        if (isUpdate) {
            ArrayList<DesignerVO> resultList = new ArrayList<DesignerVO>(2);
            resultList.add(transferModel.getMetaData());
            resultList.add(transferModel.getUpdateResult());
            return ResultSetFactory.createResultSet(resultList);
        }
        int pageSize = transferModel.getQsSize();
        int rowCount = transferModel.getRows();
        int cols = transferModel.getCols();
        DesignerVO metaData = transferModel.getMetaData();
        ExtMetaInfo metaInfo = BatchTransferUtil.createMetaInfo(metaData, cols);
        Object[] data = transferModel.getData();
        if (data != null) {
            return com.kingdee.cosmic.ctrl.kds.expans.model.resultset.ResultSetFactory.createMemResultSet((ExtMetaInfo)metaInfo, (Object[])data);
        }
        String segmentTag = transferModel.getTag();
        ArrayList<String> fileNameList = new ArrayList<String>(5);
        IExtQSWriter extQSWriter = null;
        if (pageSize > 0 && !StringUtil.isEmptyString((String)segmentTag)) {
            extQSWriter = ExtQSWriteFactory.getExtQSWrite((ExtMetaInfo)metaInfo);
            DesignerVOTransferSegment transferSegment = BatchTransferUtil.fetchTransferSegment(client, context, segmentTag);
            BatchTransferUtil.doWriteRowData(extQSWriter, transferSegment.getDesignerVOList(), cols);
            fileNameList.add(extQSWriter.getQSFileName());
            while (transferSegment.hasNext()) {
                extQSWriter = ExtQSWriteFactory.getExtQSWrite((ExtMetaInfo)metaInfo);
                transferSegment = BatchTransferUtil.fetchTransferSegment(client, context, segmentTag);
                BatchTransferUtil.doWriteRowData(extQSWriter, transferSegment.getDesignerVOList(), cols);
                fileNameList.add(extQSWriter.getQSFileName());
            }
        }
        return com.kingdee.cosmic.ctrl.kds.expans.model.resultset.ResultSetFactory.createQSResultSet((ExtMetaInfo)metaInfo, (int)pageSize, (int)rowCount, fileNameList);
    }

    private static void doWriteRowData(IExtQSWriter extQSWriter, List<DesignerVO> designerVOList, int cols) {
        if (designerVOList == null || designerVOList.isEmpty() || extQSWriter == null) {
            return;
        }
        try {
            for (int i = 0; i < designerVOList.size(); ++i) {
                Object[] row = new Object[cols];
                DesignerVO designerVO = designerVOList.get(i);
                Iterator iterator = designerVO.allFieldsIterator();
                int rowIdx = 0;
                while (iterator.hasNext()) {
                    String fieldName = (String)iterator.next();
                    row[rowIdx++] = designerVO.getFieldContent(fieldName);
                }
                extQSWriter.write(row);
            }
            extQSWriter.finish();
        }
        catch (Exception e) {
            logger.error((Object)"write data error.", (Throwable)e);
        }
    }

    private static ExtMetaInfo createMetaInfo(DesignerVO metaData, int cols) {
        ExtMetaInfo metaInfo = new ExtMetaInfo();
        for (int i = 0; i < cols; ++i) {
            String fieldName = metaData.fieldNameAt(i);
            int fieldType = metaData.typeAt(i);
            metaInfo.addField(fieldName, fieldName, Integer.valueOf(fieldType));
        }
        return metaInfo;
    }
}

