/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.proxy.impl;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.launcher.useragent.UserAgent;
import com.kingdee.bos.app.proxy.AbstractProxy;
import com.kingdee.bos.app.proxy.HessianClient;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.workbench.persist.IIOProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchIOProxy
extends AbstractProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbenchIOProxy.class);
    private Map<String, IOProvider> allIOProviders = new HashMap<String, IOProvider>();

    public WorkbenchIOProxy(UserAgent userAgent) {
        super(userAgent);
        this.hClient = new HessianClient("extReportDesignerService");
    }

    public IOProvider getIOProvider(String identifier) {
        IOProvider provider = this.allIOProviders.get(identifier);
        if (provider == null) {
            provider = new IOProvider(identifier);
            this.allIOProviders.put(identifier, provider);
        }
        return provider;
    }

    class FlushableByteArrayOutputStream
    extends ByteArrayOutputStream
    implements Flushable {
        private String identifier;
        private boolean flushed;

        FlushableByteArrayOutputStream(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public void flush() throws IOException {
            if (!this.flushed) {
                this.saveViewConfigByIdentifier(this.identifier, new String(this.toByteArray(), "utf-8"));
                this.flushed = true;
            }
            super.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
            super.close();
        }

        private void saveViewConfigByIdentifier(String identifier, String data) {
            try {
                WorkbenchIOProxy.this.requestServer("saveViewConfigByIdentifier", Void.TYPE, new Object[]{identifier, data});
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    class IOProvider
    implements IIOProvider {
        private String identifier;

        IOProvider(String identifier) {
            this.identifier = identifier;
        }

        public InputStream getPersistenceInputStream() {
            String data = "";
            if (StringUtil.isEmptyString((String)this.identifier)) {
                data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<workspace version=\"1.0.0\"><trim id=\"PropertyEditor_Widget_ID\" clsName=\"com.kingdee.cosmic.ctrl.workbench.ui.TrimWidgetViewport\"><trinity><type>16</type><key>Id</key><value>PropertyEditor_Widget_ID</value></trinity><trinity><type>16</type><key>Title</key><value>" + CtrlEXTMessages.getMLS((String)"propertyEditor", (String)"\u5c5e\u6027\u7f16\u8f91\u5668") + "</value></trinity><trinity><type>1</type><key>Closeable</key><value>true</value></trinity><trinity><type>16</type><key>Category</key><value>" + QingRptLauncherMessages.getMLS("general", "\u4e00\u822c") + "</value></trinity><trinity><type>17</type><key>View</key><value>com.kingdee.cosmic.ctrl.ext.rd.ui.views.peview.PropertyEditorTrimView</value></trinity></trim><trim id=\"Report_Widget_ID\" clsName=\"com.kingdee.cosmic.ctrl.workbench.ui.TrimWidgetViewport\"><trinity><type>16</type><key>Id</key><value>Report_Widget_ID</value></trinity><trinity><type>16</type><key>Title</key><value>" + CtrlEXTMessages.getMLS((String)"reportDesigner", (String)"\u62a5\u8868\u8bbe\u8ba1\u5668") + "</value></trinity><trinity><type>1</type><key>Closeable</key><value>true</value></trinity><trinity><type>16</type><key>Category</key><value>" + QingRptLauncherMessages.getMLS("general", "\u4e00\u822c") + "</value></trinity><trinity><type>17</type><key>View</key><value>com.kingdee.cosmic.ctrl.ext.rd.ui.views.scview.ReportTrimView</value></trinity></trim></workspace>";
            } else if (this.identifier.equals("Report Designer")) {
                data = "1.0.1\nReport_Widget_ID\nReport_Widget_ID  PropertyEditor_Widget_ID  VERTICAL_SPLIT  0.2000";
            } else {
                return null;
            }
            return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        }

        private String fetchViewConfigByIdentifier(String identifier) {
            return (String)WorkbenchIOProxy.this.requestServer("fetchViewConfigByIdentifier", String.class, new Object[]{identifier});
        }

        public OutputStream getPersistenceOutputStream() {
            return new FlushableByteArrayOutputStream(this.identifier);
        }

        public String toString() {
            return this.identifier == null ? "WORKBENCH" : "PERSPECTIVE:" + this.identifier;
        }
    }
}

