/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.impl.rptdesigner.interlayer.factory;

import com.kingdee.bos.app.proxy.facade.RptExecutorFacade;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtStringUtil;
import com.kingdee.bos.report.ds.vo.DesignerVO;
import com.kingdee.bos.report.ext.service.po.ExtDataSetSegment;
import com.kingdee.bos.report.ext.service.po.ExtDataSetTransModel;
import com.kingdee.bos.report.ext.service.util.Utilities;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtQSWriteFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IExtDataSetFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IExtQSWriter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtMetaInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.resultset.ResultSetFactory;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtSQLDataSetFactory
implements IExtDataSetFactory {
    private static final String PATTERN = "SQLCustomType=\"([0-9])\" ";
    private RptExecutorFacade _facade;
    private Pattern pattern;

    public ExtSQLDataSetFactory(RptExecutorFacade facade) {
        this._facade = facade;
        this.pattern = Pattern.compile(PATTERN);
    }

    public RptExecutorFacade getRptExecutorFacade() {
        return this._facade;
    }

    public ExtDataSet getDataSet(Book book, String name, String define) {
        if (ExtStringUtil.isEmptyString((String)define)) {
            return null;
        }
        ExtDataSetType oldType = ExtDataSetType.getExtDataSetType((String)define);
        if (oldType == null) {
            oldType = ExtDataSetType.SQL_KSQL;
        }
        return new ExtDataSet(book, name, oldType.trimPrefix(define), oldType);
    }

    public boolean updateDataSet(ExtDataSet ds, ExecutionContext execCtx) {
        String define = ds.getDefine();
        String meta = ds.getMeta();
        if (meta == null) {
            meta = "";
        }
        String[] metas = meta.split("#@META_SPLIT@#");
        HashMap<String, String> map = new HashMap<String, String>();
        if (metas.length == 2) {
            String[] metaKVs = metas[1].split("#@#@#");
            int len = metaKVs.length / 2 * 2;
            for (int i = 0; i < len; i += 2) {
                map.put(metaKVs[i], metaKVs[i + 1]);
            }
        }
        map.put(define, metas[0]);
        int typeindex = 0;
        for (String key : map.keySet()) {
            String metaXml = CtrlReportUtil.getObjectString(map.get(key));
            Matcher matcher = this.pattern.matcher(metaXml);
            if (!matcher.find()) {
                if (metaXml.indexOf("EnumMetaDataSet") != -1) {
                    typeindex = 0;
                    continue;
                }
                typeindex = 9;
                continue;
            }
            String customQueryType = matcher.group(1);
            typeindex = Integer.parseInt(customQueryType);
        }
        ExtDataSetTransModel transModel = this._facade.fetchExtDataSetTransModel(typeindex, ds.getAlias(), ds.getDefine(), metas[0], Utilities.makeParameterTransModelMap((Map)execCtx.getDataSetParameters()));
        if (transModel != null) {
            if (transModel.getQsRows() > 0) {
                int cols = transModel.getCols();
                int rows = transModel.getTotalRow();
                int qsRows = transModel.getQsRows();
                DesignerVO metaData = transModel.getMetaData();
                ExtMetaInfo metaInfo = this.createMetaInfo(metaData, cols);
                ArrayList<String> fileList = new ArrayList<String>(8);
                this.dsToQS(transModel.getTag(), metaInfo, fileList);
                Utilities.fillWithTransModel((ExtDataSet)ds, (ExecutionContext)execCtx, (ExtDataSetTransModel)transModel);
                ResultSet rs = ResultSetFactory.createQSResultSet((ExtMetaInfo)metaInfo, (int)qsRows, (int)rows, fileList);
                ds.setResultSetStub(rs);
                ds.setQsRows(transModel.getQsRows());
                ds.setDataRows(rows);
                ds.setCurrentGroup();
            } else {
                Utilities.fillWithTransModel((ExtDataSet)ds, (ExecutionContext)execCtx, (ExtDataSetTransModel)transModel);
            }
        }
        return true;
    }

    public void dsToQS(String tag, ExtMetaInfo metaInfo, List<String> fileList) {
        this.writeData(metaInfo, tag, fileList);
    }

    private void writeData(ExtMetaInfo metaInfo, String tag, List<String> fileList) {
        IExtQSWriter extQSWriter = null;
        ExtDataSetSegment segment = this._facade.fetchExtDataSetSegment(tag);
        if (segment != null) {
            extQSWriter = ExtQSWriteFactory.getExtQSWrite((ExtMetaInfo)metaInfo);
            this.doWriteRowData(extQSWriter, segment, metaInfo);
            fileList.add(extQSWriter.getQSFileName());
        }
        while (segment != null && segment.hasNext()) {
            extQSWriter = ExtQSWriteFactory.getExtQSWrite((ExtMetaInfo)metaInfo);
            segment = this._facade.fetchExtDataSetSegment(tag);
            this.doWriteRowData(extQSWriter, segment, metaInfo);
            fileList.add(extQSWriter.getQSFileName());
        }
    }

    private boolean doWriteRowData(IExtQSWriter extQSWriter, ExtDataSetSegment segment, ExtMetaInfo metaInfo) {
        if (segment == null || extQSWriter == null) {
            return true;
        }
        try {
            while (segment.hasNextRow()) {
                Map rowData = segment.nextRow();
                Object[] row = new Object[rowData.size() - 1];
                for (int i = 0; i < row.length; ++i) {
                    row[i] = rowData.get(metaInfo.getFieldName(i));
                }
                extQSWriter.write(row);
            }
            extQSWriter.finish();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private ExtMetaInfo createMetaInfo(DesignerVO metaData, int cols) {
        ExtMetaInfo metaInfo = new ExtMetaInfo();
        for (int i = 0; i < cols; ++i) {
            String fieldName = metaData.fieldNameAt(i);
            String alias = (String)metaData.getFieldContent(fieldName);
            int type = metaData.typeAt(i);
            metaInfo.addField(fieldName, alias, Integer.valueOf(type));
        }
        return metaInfo;
    }
}

