/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.app.xlet.impl.rptdesigner.interlayer.ui;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.xlet.impl.rptdesigner.interlayer.ui.AbstractSelectedTargetUI;
import com.kingdee.bos.app.xlet.util.InteractiveUIUtil;
import com.kingdee.bos.app.xlet.util.TableManager;
import com.kingdee.bos.extreport.manage.model.ExtReportGroupVO;
import com.kingdee.bos.extreport.manage.model.ExtReportGroupsVO;
import com.kingdee.bos.extreport.manage.model.ExtReportVO;
import com.kingdee.bos.extreport.manage.model.ExtReportsVO;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;

public class SelectedReportUI
extends AbstractSelectedTargetUI<ReportProperties> {
    private boolean isEmptyPresetInfo = false;

    @Override
    protected String getTargetName() {
        return QingRptLauncherMessages.getMLS("reportName", "\u62a5\u8868\u540d\u79f0");
    }

    @Override
    protected void kDButtonRefreshActionPerformed(ActionEvent event) {
        this.loadTree();
    }

    @Override
    protected void init() {
        super.init();
        IColumn column = this.tableReport.addColumn();
        column.setWidth(500);
        column.setSortable(true);
        IRow row = this.tableReport.addHeadRow();
        row.getCell(0).setValue((Object)this.getTargetName());
        this.setPreferredSize(new Dimension(800, 600));
        this.initBounds();
    }

    @Override
    protected void kDDirTreeValueChanged(TreeSelectionEvent event) {
        Object object = this.dirTree.getLastSelectedPathComponent();
        if (object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).getUserObject() instanceof ExtReportGroupVO) {
            if (this.selectedNode != null) {
                this.selectedNode.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
            }
            this.selectedNode = (DefaultKingdeeTreeNode)object;
            this.selectedNode.setCustomIcon(UIManager.getIcon("Tree.openIcon"));
            ExtReportGroupVO extReportGroupVO = (ExtReportGroupVO)this.selectedNode.getUserObject();
            ExtReportsVO extReportsVO = this.facade.findReportInfosByGroupId(extReportGroupVO.getExtReportGroupID());
            this.fillData(extReportsVO);
        } else {
            this.tableReport.removeRows();
        }
    }

    @Override
    protected void kDButtonOkActionPerformed(ActionEvent event) {
        ArrayList<Integer> lstIndex = TableManager.getSelectedTableIndexs(this.tableReport);
        if (lstIndex.isEmpty()) {
            WindowUtil.msgboxInfo((Object)QingRptLauncherMessages.getMLS("selectRecord", "\u8bf7\u9009\u62e9\u8bb0\u5f55\uff01"), (String)QingRptLauncherMessages.getMLS("messagePrompt", "\u6d88\u606f\u63d0\u793a"), (Component)((Object)this));
            return;
        }
        if (lstIndex.size() != 1) {
            WindowUtil.msgboxInfo((Object)QingRptLauncherMessages.getMLS("onlySelectOne", "\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\uff01"), (String)QingRptLauncherMessages.getMLS("messagePrompt", "\u6d88\u606f\u63d0\u793a"), (Component)((Object)this));
            return;
        }
        this.canceled = false;
        IRow row = this.tableReport.getRow(lstIndex.get(0).intValue());
        ExtReportVO extReportVO = (ExtReportVO)row.getUserObject();
        this.value = new ReportProperties(extReportVO.getExtReportID(), extReportVO.getExtReportName(), extReportVO.getExtReportGroupID());
        String orgID = this.facade.getContext().getUserAgent().getOrgID();
        ((ReportProperties)this.value).setDomain(orgID);
        ((ReportProperties)this.value).setStdProduct(false);
        StringBuilder buffer = new StringBuilder();
        buffer = this.processExtReportFullPath(this.selectedNode, buffer);
        buffer.append("/").append(extReportVO.getExtReportName());
        ((ReportProperties)this.value).setPathAlias(buffer.toString());
        InteractiveUIUtil.closeInteractiveUI(this);
    }

    public StringBuilder processExtReportFullPath(DefaultKingdeeTreeNode treeNode, StringBuilder buffer) {
        DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)treeNode.getParent();
        if (null == parent) {
            boolean presetGroupPerm = this.facade.getContext().getPresetGroupPerm();
            if (!presetGroupPerm) {
                buffer = new StringBuilder(treeNode.getText()).append((CharSequence)buffer);
            } else if (this.isEmptyPresetInfo) {
                buffer = new StringBuilder(treeNode.getText()).append((CharSequence)buffer);
            } else {
                buffer.delete(0, 1);
            }
            return buffer;
        }
        if (null != parent) {
            buffer = new StringBuilder(treeNode.getText()).append((CharSequence)buffer);
            buffer = new StringBuilder("/").append((CharSequence)buffer);
            return this.processExtReportFullPath(parent, buffer);
        }
        return buffer;
    }

    @Override
    protected void kDButtonCancelActionPerformed(ActionEvent event) {
        this.canceled = true;
        InteractiveUIUtil.closeInteractiveUI(this);
    }

    @Override
    protected DefaultKingdeeTreeNode buildTree() {
        this.selectedNode = null;
        ExtReportGroupsVO groupInfos = this.facade.findReportGroupInfos();
        ExtReportGroupsVO presetGroupInfos = this.facade.findPresetReportGroupInfos();
        this.isEmptyPresetInfo = null != presetGroupInfos && presetGroupInfos.isEmpty();
        DefaultKingdeeTreeNode nodeRoot = new DefaultKingdeeTreeNode((Object)"Root");
        nodeRoot.setText(QingRptLauncherMessages.getMLS("directory", "\u76ee\u5f55"));
        boolean presetGroupPerm = this.facade.getContext().getPresetGroupPerm();
        if (presetGroupPerm && presetGroupInfos != null && !presetGroupInfos.isEmpty()) {
            DefaultKingdeeTreeNode myBranch = new DefaultKingdeeTreeNode((Object)"EAS");
            myBranch.setText(QingRptLauncherMessages.getMLS("myDirectory", "\u6211\u7684\u76ee\u5f55"));
            this.convertList2Tree((List<ExtReportGroupVO>)groupInfos, myBranch);
            nodeRoot.add((MutableTreeNode)myBranch);
            DefaultKingdeeTreeNode presetBranch = new DefaultKingdeeTreeNode((Object)"EAS");
            presetBranch.setText(QingRptLauncherMessages.getMLS("presetDirectory", "\u9884\u7f6e\u76ee\u5f55"));
            this.convertList2Tree((List<ExtReportGroupVO>)presetGroupInfos, presetBranch);
            nodeRoot.add((MutableTreeNode)presetBranch);
        } else {
            this.convertList2Tree((List<ExtReportGroupVO>)groupInfos, nodeRoot);
        }
        return nodeRoot;
    }

    public void convertList2Tree(List<ExtReportGroupVO> groupVOs, DefaultKingdeeTreeNode branch) {
        ArrayList<ExtReportGroupVO> parentReportGroupVOs = new ArrayList<ExtReportGroupVO>();
        HashMap<String, ExtReportGroupVO> categoryMap = new HashMap<String, ExtReportGroupVO>();
        for (ExtReportGroupVO extReportGroupVO : groupVOs) {
            categoryMap.put(extReportGroupVO.getExtReportGroupID(), extReportGroupVO);
        }
        for (ExtReportGroupVO extReportGroupVO : groupVOs) {
            String parentID = extReportGroupVO.getParentID();
            if (StringUtils.isNotEmpty((CharSequence)parentID)) {
                ExtReportGroupVO parent = (ExtReportGroupVO)categoryMap.get(parentID);
                if (null == parent) continue;
                parent.addChild(extReportGroupVO);
                continue;
            }
            parentReportGroupVOs.add(extReportGroupVO);
        }
        this.handleTreeNode(parentReportGroupVOs, branch);
    }

    public void handleTreeNode(List<ExtReportGroupVO> parentReportGroupVOs, DefaultKingdeeTreeNode branch) {
        if (null != parentReportGroupVOs && parentReportGroupVOs.size() > 0) {
            for (ExtReportGroupVO groupVO : parentReportGroupVOs) {
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
                node.setText(groupVO.getExtReportGroupName());
                node.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
                node.setUserObject((Object)groupVO);
                if (this.selectedNode == null) {
                    this.selectedNode = node;
                    node.setCustomIcon(UIManager.getIcon("Tree.openIcon"));
                } else {
                    node.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
                }
                branch.add((MutableTreeNode)node);
                this.handleTreeNode(groupVO.getChildren(), node);
            }
        }
    }

    public void fillData(ExtReportsVO lst) {
        this.tableReport.removeRows();
        if (lst == null || lst.isEmpty()) {
            return;
        }
        for (ExtReportVO reportVO : lst) {
            IRow irow = this.tableReport.addRow();
            irow.getCell(0).setValue((Object)reportVO.getExtReportName());
            irow.setUserObject((Object)reportVO);
        }
    }
}

