/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.common.tabframework;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.datawizard.common.tabframework.IContextBetweenTabkids;
import com.kingdee.bos.datawizard.common.tabframework.IOwnerDependance;
import com.kingdee.bos.datawizard.common.tabframework.ITabkidChangeListener;
import com.kingdee.cosmic.ctrl.common.ui.tabbedpane.ILazyPane;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;

public abstract class AbstractTabkidWrapper
implements ILazyPane {
    private IOwnerDependance _ownerDependance;
    private KDPanel _ui;
    private IContextBetweenTabkids _ctx;

    public AbstractTabkidWrapper(IContextBetweenTabkids ctx) {
        this._ctx = ctx;
    }

    void bindParent(IOwnerDependance ownerDependance) {
        this._ownerDependance = ownerDependance;
        this.initTabkidChangeListener();
    }

    public final KDPanel getPanel() {
        if (this._ui == null) {
            this._ui = new KDPanel();
            try {
                this.initUI(this._ui);
            }
            catch (Exception e) {
                this._ui.setLayout((LayoutManager)new BorderLayout());
                Logger.getLogger(this.getClass()).error((Object)QingRptLauncherMessages.getMLS("pageInitializationFailed", "\u9875\u9762\u521d\u59cb\u5316\u5931\u8d25\uff01"), (Throwable)e);
                StringBuilder sb = new StringBuilder(QingRptLauncherMessages.getMLS("pageInitializationFailed", "\u9875\u9762\u521d\u59cb\u5316\u5931\u8d25\uff01"));
                StringWriter sw = new StringWriter();
                PrintWriter s = new PrintWriter(sw);
                e.printStackTrace(s);
                s.flush();
                sb.append(sw.getBuffer());
                KDTextArea comp = new KDTextArea();
                comp.setText(sb.toString());
                comp.setEditable(false);
                this._ui.add((Component)new KDScrollPane((Component)comp), (Object)"Center");
            }
        }
        return this._ui;
    }

    public final String getTabbedTitle() {
        return this.getTitle();
    }

    protected final IContextBetweenTabkids getContext() {
        return this._ctx;
    }

    protected final void fireEvent(String key) {
        this._ownerDependance.fireEvent(key);
    }

    protected final void addListener(String key, ITabkidChangeListener l) {
        this._ownerDependance.addListener(key, l);
    }

    protected abstract String getTitle();

    protected abstract void initUI(KDPanel var1) throws Exception;

    protected abstract void initTabkidChangeListener();

    protected abstract void intoThisTabkid();

    protected String verify() {
        return null;
    }

    protected String checkPermission() {
        return null;
    }

    protected Exception hasVerifyException() {
        return null;
    }

    protected abstract void outThisTabkid();

    protected void destroy() {
    }
}

