/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.common.tabframework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.app.xlet.util.exception.AppFrameworkException;
import com.kingdee.bos.datawizard.common.tabframework.AbstractTabkidWrapper;
import com.kingdee.bos.datawizard.common.tabframework.IOwnerDependance;
import com.kingdee.bos.datawizard.common.tabframework.ITabkidChangeListener;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.common.ui.tabbedpane.LazyTabbedPane;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.exception.FieldDuplicateException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class TabContainer {
    private TabbedPane _tabbedPane;
    private DepenanceForTabkids _depenanceForTabs;

    public TabContainer() {
        this.init();
    }

    private void init() {
        this._depenanceForTabs = new DepenanceForTabkids();
        this._tabbedPane = new TabbedPane();
    }

    public JComponent getUI() {
        return this._tabbedPane;
    }

    public void addTabkid(AbstractTabkidWrapper tabWrapper) {
        this._tabbedPane.setManualOperate(false);
        try {
            tabWrapper.bindParent(this._depenanceForTabs);
            this._tabbedPane.addLazyPane(tabWrapper);
        }
        finally {
            this._tabbedPane.setManualOperate(true);
        }
    }

    public void start() {
        this._tabbedPane.selected();
    }

    public boolean finished() {
        AbstractTabkidWrapper tabkid;
        int i;
        if (!this._tabbedPane.checkCurrentTabPermission()) {
            return false;
        }
        if (!this._tabbedPane.verifyCurrentTabIsOk()) {
            return false;
        }
        this.getCurrentTab().outThisTabkid();
        int c = this._tabbedPane.getTabCount();
        for (i = 0; i < c; ++i) {
            Throwable appCause;
            tabkid = (AbstractTabkidWrapper)this._tabbedPane.getLazyPane(i);
            String errorInfo = tabkid.checkPermission();
            if (StringUtil.isEmptyString((String)errorInfo)) {
                errorInfo = tabkid.verify();
            }
            if (errorInfo != null && errorInfo.length() > 0) {
                if (!StringUtil.isEmptyString((String)errorInfo)) {
                    String info = QingRptLauncherMessages.getMLS("tabPanelMessage", "\u9875\u7b7e\u3010#1\u3011#2#3".replace("#1", tabkid.getTabbedTitle()).replace("#2", StringUtil.RETURN).replace("#3", errorInfo));
                    WindowUtil.msgboxInfo((Object)info, (String)QingRptLauncherMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (Component)((Object)this._tabbedPane));
                }
                return false;
            }
            Exception verifyException = tabkid.hasVerifyException();
            if (verifyException == null) continue;
            Throwable cause = verifyException.getCause();
            if (cause instanceof BOSException && (appCause = cause.getCause()) instanceof AppFrameworkException) {
                cause = appCause;
            }
            if (cause instanceof AppFrameworkException) {
                Throwable realCause = cause.getCause();
                if (realCause instanceof FieldDuplicateException) {
                    MessageUtil.showDetailAndOK(null, QingRptLauncherMessages.getMLS("duplicateFieldNames", "\u5b58\u5728\u91cd\u590d\u7684\u5b57\u6bb5\u540d\u79f0\uff1a") + realCause.getMessage(), (Exception)realCause);
                    return false;
                }
                if (realCause != null && !(realCause instanceof AppFrameworkException)) {
                    MessageUtil.showDetailAndOK((Component)SwingUtilities.getWindowAncestor((Component)((Object)this._tabbedPane)), realCause.getMessage(), (Exception)realCause);
                    return false;
                }
            }
            MessageUtil.showDetailAndOK((Component)SwingUtilities.getWindowAncestor((Component)((Object)this._tabbedPane)), verifyException.getMessage(), verifyException);
            return false;
        }
        c = this._tabbedPane.getTabCount();
        for (i = 0; i < c; ++i) {
            tabkid = (AbstractTabkidWrapper)this._tabbedPane.getLazyPane(i);
            tabkid.destroy();
        }
        return true;
    }

    private AbstractTabkidWrapper getCurrentTab() {
        return this._tabbedPane.getCurrentTabkid();
    }

    public AbstractTabkidWrapper getLastTab() {
        return (AbstractTabkidWrapper)this._tabbedPane.getLazyPane(this._tabbedPane.getTabCount() - 1);
    }

    private static class DepenanceForTabkids
    implements IOwnerDependance {
        private Map<String, List<ITabkidChangeListener>> _listeners = new HashMap<String, List<ITabkidChangeListener>>();

        @Override
        public void addListener(String key, ITabkidChangeListener l) {
            List<ITabkidChangeListener> ls = this._listeners.get(key);
            if (ls == null) {
                ls = new ArrayList<ITabkidChangeListener>();
                this._listeners.put(key, ls);
            }
            ls.add(l);
        }

        @Override
        public void fireEvent(String key) {
            List<ITabkidChangeListener> ls = this._listeners.get(key);
            if (ls == null) {
                return;
            }
            for (ITabkidChangeListener l : ls) {
                l.tabkidChange(key);
            }
        }
    }

    private static class TabbedPane
    extends LazyTabbedPane {
        private static final long serialVersionUID = 1L;
        private AbstractTabkidWrapper _currentTabkid;
        private int _currentIdx = -1;
        private boolean _manualOperate = true;

        private TabbedPane() {
        }

        public void setManualOperate(boolean value) {
            this._manualOperate = value;
        }

        protected void onTabbedChanged(ChangeEvent e) {
            if (!this._manualOperate) {
                return;
            }
            boolean isCanJump = true;
            if (this.getSelectedIndex() != this._currentIdx) {
                isCanJump = this.verifyCurrentTabIsOk(true);
            }
            if (isCanJump) {
                try {
                    this.getCurrentTabkid().outThisTabkid();
                }
                finally {
                    this.selected();
                }
            }
        }

        public void selected() {
            this._currentIdx = this.getSelectedIndex();
            this._currentTabkid = (AbstractTabkidWrapper)super.getLazyPane(this._currentIdx);
            this._currentTabkid.intoThisTabkid();
        }

        public AbstractTabkidWrapper getCurrentTabkid() {
            if (this._currentTabkid == null) {
                throw new RuntimeException("You forgot call selected()");
            }
            return this._currentTabkid;
        }

        public boolean verifyCurrentTabIsOk() {
            return this.verifyCurrentTabIsOk(false);
        }

        public boolean checkCurrentTabPermission() {
            AbstractTabkidWrapper tabkid = this.getCurrentTabkid();
            String info = tabkid.checkPermission();
            if (!StringUtil.isEmptyString((String)info)) {
                WindowUtil.msgboxInfo((Object)info, (String)QingRptLauncherMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (Component)((Object)this));
                return false;
            }
            return true;
        }

        private boolean verifyCurrentTabIsOk(boolean isJumpBack) {
            AbstractTabkidWrapper tabkid = this.getCurrentTabkid();
            String errorInfo = tabkid.verify();
            if (!StringUtil.isEmptyString((String)errorInfo)) {
                if (isJumpBack) {
                    this._manualOperate = false;
                    this.setSelectedIndex(this._currentIdx);
                    this._manualOperate = true;
                }
                WindowUtil.msgboxInfo((Object)errorInfo, (String)QingRptLauncherMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (Component)((Object)this));
                return false;
            }
            Exception verifyException = tabkid.hasVerifyException();
            if (verifyException != null) {
                MessageUtil.showDetailAndOK((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), verifyException.getMessage(), verifyException);
            }
            return true;
        }
    }
}

