/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.adapter;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.command.ICommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TableManager {
    public static void rowSelected(KDTable kDTable_List, String[] selectedIDs) {
        if (null == selectedIDs || selectedIDs.length <= 0) {
            return;
        }
        ArrayList<String> lstSelected = new ArrayList<String>();
        int rowCount = kDTable_List.getRowCount();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                HashMap map = (HashMap)kDTable_List.getRow(i).getUserObject();
                String fid = CtrlReportUtil.getObjectString(map.get("fid"));
                if (!TableManager.exitsSelectedRow(fid, selectedIDs)) continue;
                lstSelected.add(String.valueOf(i));
            }
        }
        TableManager.setTableSelected(kDTable_List, lstSelected);
    }

    public static void rowSelected(KDTable kDTable_List, String[] selectedIDs, String keyField) {
        if (null == selectedIDs || selectedIDs.length <= 0) {
            return;
        }
        kDTable_List.getSelectManager().removeAll();
        ArrayList<String> lstSelected = new ArrayList<String>();
        int rowCount = kDTable_List.getRowCount();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                HashMap map = (HashMap)kDTable_List.getRow(i).getUserObject();
                String fid = CtrlReportUtil.getObjectString(map.get(keyField.toLowerCase()));
                if (!TableManager.exitsSelectedRow(fid, selectedIDs)) continue;
                lstSelected.add(String.valueOf(i));
            }
        }
        TableManager.setTableSelected(kDTable_List, lstSelected);
    }

    private static boolean exitsSelectedRow(String fid, String[] selectedIDs) {
        boolean flag = false;
        for (int i = 0; i < selectedIDs.length; ++i) {
            String id = selectedIDs[i];
            if (!id.equals(fid)) continue;
            return true;
        }
        return flag;
    }

    public static final void setTableSelected(final KDTable table, ArrayList lstSelected) {
        for (int i = 0; i < lstSelected.size(); ++i) {
            final int rowIndex = Integer.parseInt(CtrlReportUtil.getObjectString(lstSelected.get(i)));
            if (table.getRow(rowIndex) == null) continue;
            table.getSelectManager().add(rowIndex, 0);
            table.getLayoutManager().addCommand(new ICommand(){

                public void execute() {
                    table.scrollToVisible(rowIndex, 0);
                }

                public boolean isReversible() {
                    return false;
                }

                public void unexecute() {
                }
            });
        }
    }

    public static final List<String> getSelectedTableIndexs(KDTable kt) {
        ArrayList<String> lst = new ArrayList<String>();
        ArrayList blocks = kt.getSelectManager().getBlocks();
        int size = blocks.size();
        if (size == 1) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int i = top; i <= bottom; ++i) {
                lst.add(String.valueOf(i));
            }
        } else if (size > 1) {
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
                int top = block.getTop();
                int bottom = block.getBottom();
                for (int n = top; n <= bottom; ++n) {
                    lst.add(String.valueOf(n));
                }
            }
        }
        lst.trimToSize();
        return lst;
    }

    public static final int[] getSelectedTableIndexs2(KDTable kt) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        ArrayList blocks = kt.getSelectManager().getBlocks();
        int size = blocks.size();
        if (size == 1) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int i = top; i <= bottom; ++i) {
                lst.add(i);
            }
        } else if (size > 1) {
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
                int top = block.getTop();
                int bottom = block.getBottom();
                for (int n = top; n <= bottom; ++n) {
                    lst.add(n);
                }
            }
        }
        int[] ret = new int[lst.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)lst.get(i);
        }
        return ret;
    }

    public static final boolean isExistRowData(KDTable selectedTable, String valueField, String currentValue) {
        for (int i = 0; i < selectedTable.getRowCount(); ++i) {
            IRow row = selectedTable.getRow(i);
            HashMap map = (HashMap)row.getUserObject();
            String value = CtrlReportUtil.getObjectString(map.get(valueField));
            if (!value.equals(currentValue)) continue;
            return true;
        }
        return false;
    }

    public static final void removeExistData(KDTable selectedTable, String valueField, String currentValue) {
        for (int i = 0; i < selectedTable.getRowCount(); ++i) {
            IRow row = selectedTable.getRow(i);
            HashMap map = (HashMap)row.getUserObject();
            String value = CtrlReportUtil.getObjectString(map.get(valueField));
            if (!value.equals(currentValue)) continue;
            selectedTable.removeRow(i);
        }
    }

    public static final void insertToTable(KDTable selectedTable, String valueField, HashMap mapData, Object[] values) {
        TableManager.insertToTable(selectedTable, valueField, mapData, values, true);
    }

    public static final void insertToTable(KDTable selectedTable, String valueField, HashMap mapData, Object[] values, boolean isLocked) {
        if (null != valueField) {
            String valueField_value = CtrlReportUtil.getObjectString(mapData.get(valueField));
            TableManager.removeExistData(selectedTable, valueField, valueField_value);
        }
        IRow irow = selectedTable.addRow();
        irow.getStyleAttributes().setLocked(isLocked);
        for (int i = 0; i < values.length; ++i) {
            irow.getCell(i).setValue(values[i]);
        }
        irow.setUserObject((Object)mapData);
    }

    public static final void removeRow(KDTable table, boolean isConfirm, String message) {
        List<String> listSelect = TableManager.getSelectedTableIndexs(table);
        if (listSelect.isEmpty()) {
            return;
        }
        if (isConfirm) {
            if (message == null) {
                message = QingRptLauncherMessages.getMLS("confirmRemove", "\u786e\u5b9a\u79fb\u9664\uff1f");
            }
            if (!MessageUtil.showConfirm(message, false)) {
                return;
            }
        }
        int size = listSelect.size();
        for (int i = size - 1; i >= 0; --i) {
            int iR = Integer.parseInt(listSelect.get(i));
            table.removeRow(iR);
        }
        table.getSelectManager().removeAll();
    }
}

