/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.client;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.datawizard.edd.ctrlreport.imagelibrary.model.ExtImageModel;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;

public class ImageSelectButton
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static ImageSelectButton selectedButton;
    private static Border focusBorder;
    private static Border unFocusBorder;
    private static Color cover;
    private static final int BORDER_WIDTH = 6;
    private static final int BORDER_AND_LINE_WIDTH = 12;
    private transient Image img;
    private transient Image presetIcon = ResourceManager.getBufferedImage((String)"image_preset_big_icon.png");
    private int imageWidth;
    private int imageHeight;
    private boolean isSelected = false;
    private boolean nullImage = false;
    private boolean isMouseOn;
    private transient Object userObject;
    private transient ISelectImage selectImageListener;

    public ImageSelectButton(Image image, ISelectImage selectImageListener) {
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(140, 140));
        this.setSize(new Dimension(140, 140));
        ToolTipManager.sharedInstance().registerComponent(this);
        this.initMouseListener();
        this.nullImage = image == null || this.nullImage;
        this.img = this.nullImage ? ResourceManager.getBufferedImage((String)"image_not_exist.png") : image;
        this.setBackground(new Color(229, 229, 229));
        this.selectImageListener = selectImageListener;
        this.imageWidth = this.getWidth() - 12 - 2;
        this.imageHeight = this.getHeight() - 12 - 2;
    }

    public ImageSelectButton(Image image, int imageWidth, int imageHeight, ISelectImage selectImageListener) {
        this(image, selectImageListener);
        this.imageWidth = imageWidth - 12 - 2;
        this.imageHeight = imageHeight - 12 - 2;
    }

    private void initMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageSelectButton.this.doClick();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ImageSelectButton button = ImageSelectButton.this;
                button.isMouseOn = true;
                button.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ImageSelectButton button = ImageSelectButton.this;
                button.isMouseOn = false;
                button.repaint();
            }
        });
    }

    public void doClick() {
        if (selectedButton != null) {
            ImageSelectButton.selectedButton.isSelected = false;
            selectedButton.repaint();
        }
        selectedButton = this;
        this.isSelected = true;
        this.repaint();
        this.selectImageListener.select(this.userObject);
    }

    @Override
    public void paintBorder(Graphics g) {
        if (this.isSelected) {
            focusBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        } else {
            unFocusBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            if (this.isMouseOn) {
                Color old = g.getColor();
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(cover);
                g2.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
                g2.setColor(old);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        ExtImageModel imageModel;
        super.paint(g);
        int x = (this.getWidth() - this.imageWidth) / 2;
        int y = (this.getHeight() - this.imageHeight) / 2;
        g.setColor(this.isMouseOn ? new Color(255, 239, 209) : new Color(231, 237, 242));
        g.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
        g.setColor(new Color(128, 128, 128));
        g.drawRect(5, 5, this.getWidth() - 12, this.getHeight() - 12);
        g.setColor(new Color(255, 255, 255));
        g.fillRect(6, 6, this.getWidth() - 12 - 2, this.getHeight() - 12 - 2);
        if (this.nullImage) {
            g.setColor(this.getBackground());
            g.fillRect(6, 6, this.getWidth() - 12 - 2, this.getHeight() - 12 - 2);
        }
        g.setColor(null);
        g.drawImage(this.img, x, y, this.imageWidth, this.imageHeight, null);
        if (this.isSelected) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
            Color color = new Color(0, 0, 255, 180);
            g2.setColor(color);
            g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            g2.dispose();
        }
        if ((imageModel = (ExtImageModel)this.userObject).isPreset()) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.rotate(-0.707, this.getWidth() - 28, 28.0);
            g2.drawImage(this.presetIcon, this.getWidth() - 55, 1, 54, 54, null);
            g2.setColor(new Color(178, 178, 178));
            g2.setFont(new Font(null, 0, 13));
            g2.drawString(QingRptLauncherMessages.getMLS("preset", "\u9884\u7f6e"), this.getWidth() - 40, 33);
            g2.dispose();
        }
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    static {
        focusBorder = BorderFactory.createLoweredBevelBorder();
        unFocusBorder = BorderFactory.createRaisedBevelBorder();
        cover = new Color(255, 239, 209);
    }

    static interface ISelectImage {
        public void select(Object var1);
    }
}

