/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.client;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.boslayer.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.boslayer.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.corelayer.proxy.IImageLibProxy;
import com.kingdee.bos.corelayer.proxy.ProxyFactory;
import com.kingdee.bos.datawizard.edd.ctrlreport.client.ImageSelectButton;
import com.kingdee.bos.datawizard.edd.ctrlreport.imagelibrary.model.ExtImageModel;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.bos.report.ds.vo.DesignerVO;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table.Cell;
import com.kingdee.cosmic.ctrl.common.ui.TypicalDialog;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLayout;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDSplitPane;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.KDTreeView;
import com.kingdee.cosmic.ctrl.swing.MessageDialog;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ImageSelectUI
extends TypicalDialog {
    private static Logger log = LogUtil.getPackageLogger(ImageSelectUI.class);
    private KDSplitPane kDSplitPane1;
    private KDTreeView kDTreeView1;
    protected KDSeparator kDSeparator2;
    private KDTree kDTree1;
    private KDPanel kDImageContainer;
    private JScrollPane kdScrollPane;
    private Context _ctx;
    private ExtImageModel imageModel = null;
    private List<String> reservedNodeUUID = Arrays.asList((Object[])new String[]{"root", "public_id", "private_id", "public_user_gallery_id", "public_download_gallery_id", "priavte_user_gallery_id", "priavte_download_gallery_id"});

    public ImageSelectUI() {
    }

    public ImageSelectUI(Context context) {
        this();
        this._ctx = context;
    }

    public ImageSelectUI(Frame win, Context context) {
        super(win);
        this._ctx = context;
    }

    public ImageSelectUI(Dialog dialog, Context context) {
        super(dialog);
        this._ctx = context;
    }

    public static ImageSelectUI create(Component parentCtrl, Context context) {
        Window win = null;
        win = parentCtrl instanceof Window ? (Window)parentCtrl : SwingUtilities.getWindowAncestor(parentCtrl);
        if (win instanceof Frame) {
            return new ImageSelectUI((Frame)win, context);
        }
        if (win instanceof Dialog) {
            return new ImageSelectUI((Dialog)win, context);
        }
        return new ImageSelectUI(context);
    }

    protected void todoInit() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
    }

    protected boolean verify() {
        if (this.imageModel == null) {
            MessageUtil.showInfo("selectRecord", true, QingRptLauncherMessages.getMLS("selectRecord", "\u8bf7\u9009\u62e9\u8bb0\u5f55\uff01"));
            return false;
        }
        if (this.imageModel.getThumbnailContent() == null) {
            MessageDialog.show((Component)this.getParent(), (Object)CtrlEXTMessages.getMLS((String)"imageNotFound", (String)"\u9009\u62e9\u56fe\u7247\u4e0d\u5b58\u5728\uff01"), (String)QingRptLauncherMessages.getMLS("infoTips", "\u4fe1\u606f\u63d0\u793a"), (int)-1, (int)1);
            return false;
        }
        return true;
    }

    private void jbInit() {
        this.setTitle(QingRptLauncherMessages.getMLS("selectImage", "\u9009\u62e9\u56fe\u7247"));
        this.setResizable(false);
        this.kDSplitPane1 = new KDSplitPane();
        this.kDTreeView1 = new KDTreeView();
        this.kDSeparator2 = new KDSeparator();
        this.kDTree1 = new KDTree();
        this.kDImageContainer = new KDPanel((LayoutManager)new FlowLayout(0, 15, 15));
        this.kdScrollPane = new KDScrollPane((Component)this.kDImageContainer);
        this.kdScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.kDSplitPane1.setName("kDSplitPane1");
        this.kDTreeView1.setName("kDTreeView1");
        this.kDSeparator2.setName("kDSeparator2");
        this.kDTree1.setName("kDTree1");
        this.kDImageContainer.setName("kDImageContainer1");
        this.kDSplitPane1.setDividerLocation(240);
        this.kDSplitPane1.setDividerSize(8);
        this.kDTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    ImageSelectUI.this.kDTree1_valueChanged(e);
                }
                catch (Exception ex) {
                    log.error((Object)"Load images has error.", (Throwable)ex);
                }
            }
        });
        this.initUIContentLayout();
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 800, 600));
        this.setLayout((LayoutManager)new KDLayout());
        this.kDSplitPane1.setBounds(new Rectangle(5, 7, 787, 520));
        this.add((Component)this.kDSplitPane1, new KDLayout.Constraints(5, 7, 787, 545, 15));
        this.kDSeparator2.setBounds(new Rectangle(0, 529, 800, 10));
        this.add((Component)this.kDSeparator2, new KDLayout.Constraints(0, 560, 800, 10, 14));
        this.kDSplitPane1.add((Component)this.kDTreeView1, (Object)"left");
        this.kDSplitPane1.add((Component)this.kdScrollPane, (Object)"right");
        this.kDTreeView1.setTree(this.kDTree1);
    }

    public void prepare() throws Exception {
        this.initTree();
    }

    private void convertToTreeNode(IBriefViewTreeNode root, DefaultKingdeeTreeNode nodeRoot) {
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)enu.nextElement();
            String strNodeName = bvNode.getAlias();
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setText(strNodeName);
            node.setUserObject((Object)bvNode);
            node.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
            nodeRoot.add((MutableTreeNode)node);
            this.convertToTreeNode(bvNode, node);
        }
    }

    private void initTree() {
        IImageLibProxy imageLibProxy = ProxyFactory.createImageLibProxy((Object)((Object)this._ctx));
        IBriefViewTreeNode root = (IBriefViewTreeNode)imageLibProxy.getSubSystemTree();
        DefaultKingdeeTreeNode nodeRoot = new DefaultKingdeeTreeNode((Object)"EAS");
        nodeRoot.setText(QingRptLauncherMessages.getMLS("directory", "\u76ee\u5f55"));
        nodeRoot.setUserObject((Object)root);
        this.convertToTreeNode(root, nodeRoot);
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)nodeRoot));
        ((KingdeeTreeModel)this.kDTree1.getModel()).setAsksAllowsChildren(false);
        this.kDTree1.getSelectionModel().setSelectionMode(1);
        this.kDTree1.setAutoscrolls(true);
        this.kDTree1.expandAllNodes(true, (TreeNode)nodeRoot);
        DefaultMutableTreeNode firstLeaf = nodeRoot.getFirstLeaf();
        this.kDTree1.setSelectionNode((DefaultKingdeeTreeNode)firstLeaf);
    }

    public ExtImageModel getSelectedRes() {
        return this.imageModel;
    }

    private void kDTree1_valueChanged(TreeSelectionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode;
        MetaDataBriefInfo bvNode;
        String categoryId;
        this.kDImageContainer.removeAll();
        Object object = this.kDTree1.getLastSelectedPathComponent();
        if (object instanceof DefaultKingdeeTreeNode && !this.reservedNodeUUID.contains(categoryId = (bvNode = (MetaDataBriefInfo)(treeNode = (DefaultKingdeeTreeNode)object).getUserObject()).getFullName())) {
            DesignerVO designerVO = bvNode.getDesignerVO();
            String isPublic = (String)designerVO.getFieldContent("isPublic");
            IImageLibProxy imageLibProxy = ProxyFactory.createImageLibProxy((Object)((Object)this._ctx));
            String categoryName = (String)designerVO.getFieldContent("name");
            List images = imageLibProxy.getAllImageOfCategory(categoryId, "true".equals(designerVO.getFieldContent("isPreset")));
            int contentHeight = 0;
            for (int i = 0; i < images.size(); ++i) {
                ExtImageModel extImageModel = (ExtImageModel)images.get(i);
                extImageModel.setPublic(Boolean.parseBoolean(isPublic));
                extImageModel.setCategoryName(categoryName);
                KDLabel imageLabel = this.createImageLabel(extImageModel);
                if (i % 3 == 0) {
                    contentHeight += 195;
                }
                this.kDImageContainer.add((Component)imageLabel);
            }
            if (images.isEmpty()) {
                ImageIcon imageIcon = ResourceManager.getImageIcon((String)"no_data.png");
                KDLabel noDataKDLabel = new KDLabel(CtrlEXTMessages.getMLS((String)"noImage", (String)"\u6682\u65e0\u56fe\u7247"), (Icon)imageIcon, 0);
                Font font = new Font(QingRptLauncherMessages.getMLS("microsoftYaHei", "\u5fae\u8f6f\u96c5\u9ed1"), 0, 16);
                noDataKDLabel.setFont(font);
                noDataKDLabel.setBackground(new Color(231, 237, 242, 230));
                noDataKDLabel.setForeground(new Color(187, 187, 187));
                noDataKDLabel.setVerticalTextPosition(3);
                noDataKDLabel.setHorizontalTextPosition(0);
                noDataKDLabel.setBounds(100, 100, 220, 252);
                noDataKDLabel.setIconTextGap(20);
                noDataKDLabel.setPreferredSize(new Dimension(510, 500));
                this.kDImageContainer.add((Component)noDataKDLabel);
                this.kDImageContainer.setPreferredSize(new Dimension(510, 500));
            } else {
                this.kDImageContainer.setPreferredSize(new Dimension(510, contentHeight));
            }
        }
        this.kDImageContainer.updateUI();
    }

    private KDLabel createImageLabel(ExtImageModel extImageModel) {
        KDLabel tempLabel = new KDLabel();
        Image image = null;
        ImageIcon imageIcon = null;
        ImageSelectButton selectButton = null;
        KDLabel textLabel = new KDLabel();
        String imageName = extImageModel.getImageName();
        byte[] thumbnailContent = extImageModel.getThumbnailContent();
        tempLabel.setName(imageName);
        ImageSelectButton.ISelectImage selectImageListener = new ImageSelectButton.ISelectImage(){

            @Override
            public void select(Object userObject) {
                if (userObject instanceof ExtImageModel) {
                    ImageSelectUI.this.imageModel = (ExtImageModel)userObject;
                }
            }
        };
        if (thumbnailContent == null) {
            selectButton = new ImageSelectButton(null, 33, 33, selectImageListener);
        } else {
            imageIcon = new ImageIcon(thumbnailContent);
            image = imageIcon.getImage();
            int[] imageLimitSize = extImageModel.getImageLimitSize(140);
            selectButton = new ImageSelectButton(image, imageLimitSize[0], imageLimitSize[1], selectImageListener);
        }
        selectButton.setUserObject(extImageModel);
        textLabel.setBounds(new Rectangle(0, 150, 150, 30));
        textLabel.setPreferredSize(new Dimension(150, 30));
        textLabel.setText(imageName);
        textLabel.setHorizontalAlignment(0);
        tempLabel.setBackground(new Color(183, 183, 255));
        tempLabel.add((Component)selectButton);
        tempLabel.add((Component)textLabel);
        tempLabel.setPreferredSize(new Dimension(150, 180));
        tempLabel.setUserObject((Object)extImageModel);
        return tempLabel;
    }
}

