/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.client;

import com.kingdee.bos.app.xlet.util.exception.AppFrameworkException;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.boslayer.bos.ui.face.CoreUIObject;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.KSQLReportBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.client.AbstractPreviewDbSourceUI;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoExisitException;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlreport.datasetfactory.IExtendReport;
import com.kingdee.bos.datawizard.edd.ctrlreport.datasetfactory.IGUICommonDataSet;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.ExtBizData;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.PreviewKSQLPanelUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.SuperQueryNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DataSetDefineModel;
import com.kingdee.bos.extreport.utils.CloseUtil;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PreviewDbSourceUI
extends AbstractPreviewDbSourceUI {
    private static final long serialVersionUID = -884013313788912234L;
    private static final Logger logger = CoreUIObject.getLogger(PreviewDbSourceUI.class);
    private boolean isinitLayout = false;
    private boolean isCancel = false;
    String define;
    ExtBizData ebd;
    private Context _ctx;

    public PreviewDbSourceUI(Context ctx) throws Exception {
        this._ctx = ctx;
        this.tblContent.checkParsed();
        this.initLayout();
        this.spnTop.setModel((SpinnerModel)new SpinnerNumberModel(50, 1, 1000, 1));
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    private int getTopNumber() {
        return this.spnTop.getIntegerVlaue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean isRefresh) {
        try {
            int rowCount = this.getTopNumber();
            if (rowCount == -1) {
                rowCount = Integer.MAX_VALUE;
            }
            this.tblContent.removeColumns();
            if (this.ebd == null) {
                this.ebd = new ExtBizData();
            }
            IExtendReport iExtendReport = KSQLReportBO.getExtendReport((Object)((Object)this._ctx), (String)this.define);
            if (!isRefresh) {
                IGUICommonDataSet guiCommonDataSet = (IGUICommonDataSet)iExtendReport;
                boolean isConfirm = guiCommonDataSet.showFilterDialog(null);
                if (!isConfirm) {
                    this.isCancel = true;
                    return;
                }
                Map params = guiCommonDataSet.getParamInfo();
                this.ebd.setParams(params);
            }
            this.ebd.execute(iExtendReport, 0, rowCount);
            CtrlDesignQueryModel model = null;
            DataSetDefineModel dataSetDefineModel = DataSetDefineModel.parseDefine((String)this.define);
            String dataSetType = dataSetDefineModel.getType();
            if (dataSetType.equals("sql_ksql") || dataSetType.equals("sql_oql")) {
                String dbsourceid = dataSetDefineModel.getId();
                model = KSQLReportBO.initModel((Object)((Object)this._ctx), (String)dbsourceid, null);
            }
            ResultSet rs = this.ebd.getRs();
            try {
                PreviewKSQLPanelUI.addResultSet(this.tblContent, rs, model);
            }
            finally {
                CloseUtil.close((ResultSet)rs);
            }
        }
        catch (AppFrameworkException e) {
            if (e.getCause() instanceof ExtDataSetNoPermissionException || e.getCause() instanceof ExtDataSetNoExisitException || e.getCause() instanceof ExtMacroException || e.getCause() instanceof DataCenterNoPermissionException) {
                MessageUtil.showDetailAndOK(null, e.getCause().getMessage(), e);
                throw e;
            }
            logger.error((Object)"PreviewDbSourceUI.execute", (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof CtrlReportException || e instanceof SuperQueryNoPermissionException) {
                MessageUtil.showDetailAndOK(null, e.getMessage(), e);
                throw new AppFrameworkException(e.getMessage(), e);
            }
            logger.error((Object)"PreviewDbSourceUI.execute", (Throwable)e);
        }
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.execute(true);
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setDefine(String define) {
        this.define = define;
    }

    protected KDTable getTableForCommon() {
        return this.tblContent;
    }
}

