/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlreport.macro.ui.designer;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.boslayer.eas.framework.client.CoreUI;
import com.kingdee.bos.boslayer.eas.util.client.EASResource;
import com.kingdee.bos.boslayer.eas.util.client.MsgBox;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroType;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroVO;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtPreviewData;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.MacroUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLayout;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MacroValueDisplayPanel
extends CoreUI {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(MacroValueDisplayPanel.class);
    private ExtMacroVO macro;
    private KDTable previewTable;
    private Context context;

    public MacroValueDisplayPanel(ExtMacroVO macro) {
        this.macro = macro;
        this.initUIContentLayout();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.getTableForCommon();
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 10, 998, 613);
        cons.anchor = 15;
        this.previewTable.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.add((Component)this.previewTable);
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1013, 629));
        this.setLayout((LayoutManager)new KDLayout());
        this.setPreferredSize(new Dimension(480, 300));
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        KDToolBar toolBar = this.getUIToolBar();
        if (toolBar != null) {
            toolBar.add((Action)new RefreshAction());
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.refreshTable(true);
    }

    public void showInModalDialog(Component parent) {
        if (!(parent instanceof Window)) {
            parent = SwingUtilities.getWindowAncestor(parent);
        }
        final KDDialog dialog = parent instanceof Frame ? new KDDialog((Frame)parent) : (parent instanceof Dialog ? new KDDialog((Dialog)parent) : new KDDialog());
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setTitle(QingRptLauncherMessages.getMLS("previewMacro", "\u9884\u89c8\u5b8f") + "\u3010" + this.macro.getName() + "\u3011");
        KDPanel dialogPanel = new KDPanel((LayoutManager)new BorderLayout());
        dialogPanel.add((Component)((Object)this));
        this.refreshTable(true);
        KDPanel southPanel = new KDPanel((LayoutManager)new BorderLayout());
        KDPanel controlPanel = new KDPanel((LayoutManager)new FlowLayout(2, 6, 6));
        KDButton confirm = new KDButton(QingRptLauncherMessages.getMLS("confirmBtn", "\u786e\u5b9a"));
        confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        controlPanel.add((Component)confirm);
        southPanel.add((Component)new KDSeparator(), (Object)"North");
        southPanel.add((Component)controlPanel, (Object)"South");
        dialogPanel.add((Component)southPanel, (Object)"South");
        dialog.setContentPane((Container)dialogPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.show();
    }

    private void refreshTable(boolean isShouldAbort) {
        ExtPreviewData macroValues = null;
        try {
            macroValues = MacroUtil.loadPreviewMacroValue((Object)((Object)this.context), (String)this.macro.getFid(), (ExtMacroType)this.macro.getType());
        }
        catch (Exception e) {
            logger.error((Object)"failed to execute", (Throwable)e);
            MsgBox.showInfo((Component)((Object)this), QingRptLauncherMessages.getMLS("getMacroValueFailed", "\u83b7\u53d6\u5b8f\u503c\u5931\u8d25\uff1a") + this.macro.getFid());
            if (isShouldAbort) {
                this.abort();
            }
            return;
        }
        this.previewTable.removeRows();
        this.previewTable.removeHeadRows();
        this.previewTable.removeColumns();
        IRow headRow0 = this.previewTable.addHeadRow();
        boolean isFirst = true;
        List fields = macroValues.getFields();
        int fieldNum = CollectionUtils.isEmpty((Collection)fields) ? 0 : fields.size();
        List noPermFieldIndex = macroValues.getNoPermFieldIndex();
        for (int i = 0; i < fieldNum; ++i) {
            String macroValue = (String)fields.get(i);
            this.previewTable.addColumn().setKey(macroValue);
            this.previewTable.getColumn(macroValue).setWidth(200);
            if (CollectionUtils.isNotEmpty((Collection)noPermFieldIndex) && noPermFieldIndex.contains(i)) {
                headRow0.getCell(macroValue).setValue((Object)(macroValue + QingRptLauncherMessages.getMLS("unauthorized", "\uff08\u672a\u6388\u6743\uff09")));
                continue;
            }
            headRow0.getCell(macroValue).setValue((Object)(macroValue + (isFirst ? QingRptLauncherMessages.getMLS("macroValue", "\uff08\u5b8f\u503c\uff09") : "")));
            isFirst = false;
        }
        if (CollectionUtils.isNotEmpty((Collection)macroValues.getRows())) {
            for (ExtPreviewData.Row dataRow : macroValues.getRows()) {
                IRow row = this.previewTable.addRow();
                int index = 0;
                for (ExtPreviewData.Column column : dataRow.getColumns()) {
                    boolean hasPermission = CollectionUtils.isEmpty((Collection)noPermFieldIndex) || !noPermFieldIndex.contains(index);
                    Object value = hasPermission ? column.getValue() : "***";
                    row.getCell(index).setValue(value);
                    ++index;
                }
            }
        }
    }

    protected KDTable getTableForCommon() {
        this.previewTable = new KDTable();
        this.previewTable.getSelectManager().setSelectMode(10);
        this.previewTable.setName("MacroValueDisplayPreviewTable");
        return this.previewTable;
    }

    @Override
    public boolean destroyWindow() {
        return true;
    }

    @Override
    public String getUITitle() {
        return (String)this.getUIContext().get("MainMenuName");
    }

    public void setContext(Context context) {
        this.context = context;
    }

    private class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        RefreshAction() {
            super(KDResourceManager.getMLS((String)"refresh", (String)"\u5237\u65b0"), EASResource.getIcon((String)"imgTbtn_refresh"));
            this.putValue("ShortDescription", KDResourceManager.getMLS((String)"refresh", (String)"\u5237\u65b0"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MacroValueDisplayPanel.this.refreshTable(false);
        }
    }
}

