/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client;

import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.DateSettingModel;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.DateTransUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.ExtStringUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.AbstractDateTimeSettingUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.extreport.utils.JsonUtil;
import com.kingdee.bos.extreport.utils.StringUtils;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class DateTimeSettingUI
extends AbstractDateTimeSettingUI {
    private static final Logger logger = DateTimeSettingUI.getLogger(DateTimeSettingUI.class);
    private DateSettingModel primitiveModel = null;

    public DateTimeSettingUI() throws Exception {
    }

    public DateTimeSettingUI(DateSettingModel model, Context ctx) throws Exception {
        this();
        this.ctx = ctx;
        this.primitiveModel = model;
        this.resolveModel2UI(model);
    }

    public String getDateSelected() {
        DateSettingModel ret = new DateSettingModel();
        ret.setDateGran(DateSettingModel.DateGranEnum.Y_M_D);
        ret.setDateType(DateSettingModel.DateTypeEnum.values()[this.kdButtonGroup1.getValue()]);
        String value = "";
        switch (ret.getDateType()) {
            case PERM: {
                value = CtrlReportUtil.getObjectString((Object)this.kDDatePickerPerm.getText());
                if (StringUtils.isEmpty((CharSequence)value)) break;
                String pattern = this.kDDatePickerPerm.getDatePattern();
                value = CtrlReportUtil.formatDate((String)pattern.trim(), (String)"yyyy-MM-dd HH:mm:ss", (String)value);
                break;
            }
            case EXPR: {
                value = this.kDTextFieldExpr.getText().trim();
                break;
            }
            case RELATIVE: {
                DateSettingModel.TimeTypeEnum timeTypeEnum;
                StringBuilder sb = new StringBuilder();
                sb.append(DateSettingModel.DateOffsetPathEnum.values()[this.kDComboBoxFrontBack.getSelectedIndex()]).append("!@#ORANGE#@!");
                sb.append(this.kDSpinnerOffset.getValue()).append("!@#ORANGE#@!");
                DateSettingModel.DateUnitEnum dateUnitEnum = DateSettingModel.DateUnitEnum.values()[this.kDComboBoxOffsetUnit.getSelectedIndex()];
                sb.append(dateUnitEnum).append("!@#ORANGE#@!");
                if (DateSettingModel.DateUnitEnum.DAY != dateUnitEnum) {
                    sb.append(DateSettingModel.DateOffsetDayEnum.values()[this.kDComboBoxFirstLast.getSelectedIndex()]).append("!@#ORANGE#@!");
                }
                if (DateSettingModel.TimeTypeEnum.SYS == (timeTypeEnum = DateSettingModel.TimeTypeEnum.values()[this.kdButtonGroup2.getValue()])) {
                    sb.append("getSystemTime()");
                } else {
                    String time = CtrlReportUtil.getObjectString((Object)this.kDTimePickerPerm.getText());
                    if (!StringUtils.isEmpty((CharSequence)time)) {
                        String formatString = "HH:mm:ss";
                        String pattern = this.kDTimePickerPerm.getTimePattern();
                        time = CtrlReportUtil.formatDate((String)pattern, (String)formatString, (String)time);
                    }
                    sb.append(time);
                }
                value = sb.toString();
                break;
            }
        }
        ret.setValue(value);
        return JsonUtil.encodeToString((Object)ret);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private void resolveModel2UI(DateSettingModel model) {
        this.kDDatePickerPerm.setTimeEnabled(true);
        this.kDDatePickerPerm.setValue(null);
        this.kDRadioButtonSysTime.setSelected(true);
        this.kDSpinnerOffset.setNullable(false);
        switch (model.getDateType()) {
            case PERM: {
                this.kDRadioButtonPerm.setSelected(true);
                String datePatternOld = this.kDDatePickerPerm.getDatePattern();
                String datePatternNew = this.kDDatePickerPerm.getDatePattern();
                this.kDDatePickerPerm.setDatePattern(ExtStringUtil.replace((String)datePatternNew, (String)datePatternOld, (String)(datePatternOld + " ")));
                Date date = null;
                if (StringUtils.isNotEmpty((CharSequence)model.getValue())) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        date = sdf.parse(model.getValue());
                    }
                    catch (ParseException e) {
                        logger.error((Object)("DateTimeSettingUI parse date error:" + model.getValue()), (Throwable)e);
                    }
                }
                this.kDDatePickerPerm.setValue(date);
                break;
            }
            case EXPR: {
                this.kDRadioButtonExpr.setSelected(true);
                this.kDTextFieldExpr.setText(model.getValue());
                break;
            }
            case RELATIVE: {
                this.kDRadioButtonRelative.setSelected(true);
                String[] splitValue = DateTransUtil.splitValue((String)model.getValue());
                if (splitValue.length < 3) break;
                this.kDComboBoxFrontBack.setSelectedIndex(DateSettingModel.DateOffsetPathEnum.valueOf((String)splitValue[0]).ordinal());
                this.kDSpinnerOffset.setValue((Object)Integer.parseInt(splitValue[1]));
                this.kDComboBoxOffsetUnit.setSelectedIndex(DateSettingModel.DateUnitEnum.valueOf((String)splitValue[2]).ordinal());
                if (splitValue.length < 4) break;
                String timeValue = null;
                if (splitValue[3].equals(DateSettingModel.DateOffsetDayEnum.FIRST_DAY.name()) || splitValue[3].equals(DateSettingModel.DateOffsetDayEnum.LAST_DAY.name())) {
                    this.kDLabelOf.setVisible(true);
                    this.kDComboBoxFirstLast.setVisible(true);
                    this.kDComboBoxFirstLast.setSelectedIndex(DateSettingModel.DateOffsetDayEnum.valueOf((String)splitValue[3]).ordinal());
                    if (splitValue.length == 5) {
                        timeValue = splitValue[4];
                    }
                } else {
                    timeValue = splitValue[3];
                }
                if ("getSystemTime()".equals(timeValue)) {
                    this.kDRadioButtonPermTime.setSelected(false);
                    this.kDRadioButtonSysTime.setSelected(true);
                    break;
                }
                this.kDRadioButtonSysTime.setSelected(false);
                this.kDRadioButtonPermTime.setSelected(true);
                String formatString = "HH:mm:ss";
                Date dateTime = null;
                if (StringUtils.isNotEmpty((CharSequence)timeValue)) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat(formatString);
                        dateTime = sdf.parse(timeValue);
                    }
                    catch (ParseException e) {
                        logger.error((Object)("DateTimeSettingUI parse dateTime error:" + model.getValue()), (Throwable)e);
                    }
                } else {
                    dateTime = RunReportParam.getServerDate((Object)((Object)this.ctx));
                }
                this.kDTimePickerPerm.setValue((Object)dateTime);
                break;
            }
            default: {
                logger.error((Object)("unknown DateTimeSettingModel dateType:" + model.getDateType()));
            }
        }
    }

    @Override
    protected void resetActionPerformed(ActionEvent e) {
        this.resolveModel2UI(this.primitiveModel);
    }
}

