/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.boslayer.bos.ui.face.CoreUIObject;
import com.kingdee.bos.boslayer.eas.util.client.MsgBox;
import com.kingdee.bos.corelayer.proxy.IExtFilterSchemeProxy;
import com.kingdee.bos.corelayer.proxy.ProxyFactory;
import com.kingdee.bos.datawizard.common.tabframework.TabContainer;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.KSQLReportBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.client.ReportDialog;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.AbstractDesignUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.ITabUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.KSQLNameUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.OutputFieldsUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.PreviewKSQLPanelUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CycleException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignInputStream;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignOutputStream;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.datawizard.edd.model.EDDContextBetweenTabkids;
import com.kingdee.bos.datawizard.edd.tabkid.OqlUITabkidWrapper;
import com.kingdee.bos.datawizard.edd.tabkid.OutDBUITabkidWrapper;
import com.kingdee.bos.datawizard.edd.tabkid.OutputFieldsUITabkidWrapper;
import com.kingdee.bos.datawizard.edd.tabkid.ParamUITabkidWrapper;
import com.kingdee.bos.datawizard.edd.tabkid.SqlUITabkidWrapper;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.bos.report.ext.model.SQLCustomType;
import com.kingdee.bos.report.ext.web.scheme.po.ExtFilterScheme;
import com.kingdee.cosmic.ctrl.common.util.StreamUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.query.Column;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.swing.KDLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class DesignUI
extends AbstractDesignUI {
    private static final long serialVersionUID = -5782922810898448416L;
    private static final Logger logger = CoreUIObject.getLogger(DesignUI.class);
    protected ITabUI tabUI = null;
    private CtrlDesignQueryModel model;
    private HashMap<String, Object> mapData = null;
    public boolean isOnLoadStart = false;
    public boolean isinitLayout = false;
    private boolean isNoFoundQuery = false;
    private SQLCustomType customType;
    private ExtDataSet dataset;
    boolean isNew = true;
    boolean isCanceld = true;
    private Pattern correctAliasPattern = Pattern.compile("^(?![0-9])[a-zA-Z0-9_\\u4e00-\\u9fa5]+$");
    private TabContainer _tc = new TabContainer();
    private EDDContextBetweenTabkids _tdbUICtx = new EDDContextBetweenTabkids(this);
    private PreviewKSQLPanelUI previewPanel;

    public DesignUI(Context ctx) throws Exception {
        this.ctx = ctx;
    }

    @Override
    public void onLoad() {
        this.isOnLoadStart = true;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDTabbedPane1.removeAll();
    }

    private String getModelXml() {
        RunReportParam.setSQLVersion((CtrlDesignQueryModel)this.model);
        IXmlElement xml = CtrlDesignUtil.toXml((Object)((Object)this.ctx), (CtrlDesignCommonQuery)this.model.getCommonQuery(), (IQuery)this.model.getQuery());
        return XmlUtil.toString((IXmlElement)xml);
    }

    public void refresh() {
        this.initLayout();
        this.initModel();
        this.initFirstTab();
    }

    private void initModel() {
        if (this.getModel() != null) {
            this.btnSaveAs.setEnabled(false);
        } else {
            String fid = CtrlReportUtil.getObjectString((Object)this.mapData.get("fid"));
            this.model = new CtrlDesignQueryModel();
            if (fid.length() == 0) {
                this.model.setQuery((IQuery)new CtrlDesignKsqlQuery(true));
            } else {
                CtrlDesignInputStream in = new CtrlDesignInputStream((Object)this.ctx, fid);
                try {
                    in.getInputObject(this.model, null);
                }
                catch (CycleException cycleException) {
                    // empty catch block
                }
                this.isNew = false;
            }
        }
        CtrlDesignCommonQuery commonQuery = this.model.getCommonQuery();
        commonQuery.getProperties().put(CtrlDesignUtil.CustomType, String.valueOf(this.customType.intValue()));
    }

    public void noFoundQuerySetup() {
        this.isNoFoundQuery = true;
        this.btnSaveAs.setEnabled(false);
        if (this.ctx.getSeessionSQLDesignerProxy().getContext().getPreset()) {
            this.btnOK.setEnabled(false);
        }
    }

    private void initFirstTab() {
        this._tc.getUI().setBounds(new Rectangle(5, 5, 788, 549));
        this.add(this._tc.getUI(), new KDLayout.Constraints(5, 5, 788, 549, 418));
        this.remove((Component)this.kDTabbedPane1);
        this.add(this._tc.getUI());
        if (this.customType == SQLCustomType.OQL) {
            this._tc.addTabkid(new OqlUITabkidWrapper(this._tdbUICtx));
        } else {
            this._tc.addTabkid(new OutDBUITabkidWrapper(this._tdbUICtx));
            this._tc.addTabkid(new SqlUITabkidWrapper(this._tdbUICtx));
        }
        this._tc.addTabkid(new ParamUITabkidWrapper(this._tdbUICtx));
        this._tc.addTabkid(new OutputFieldsUITabkidWrapper(this._tdbUICtx));
        this._tc.start();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.destroyWindow();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        CtrlReportUtil.closeWin((Component)((Object)this));
    }

    @Override
    protected void btnPreview_actionPerformed(ActionEvent e) throws Exception {
        this._tdbUICtx.setPreviewing(true);
        if (!this._tc.finished()) {
            return;
        }
        this.previewPanel = new PreviewKSQLPanelUI(this);
        String solutionId = this.findNextIntoSolutionId();
        this.previewPanel.setSolutionID(solutionId);
        if (this.previewPanel.preview(false, true, StringUtils.isEmpty((CharSequence)solutionId))) {
            this._tdbUICtx.setNeedRefresh(false);
            this._tdbUICtx.setPreviewing(false);
            this._tc.finished();
        }
        if (this.previewPanel.isShowPreviewUI()) {
            String message = QingRptLauncherMessages.getMLS("preview", "\u9884\u89c8");
            ReportDialog.showDialog(this.previewPanel, message, true, false);
        }
        this.previewPanel = null;
        this._tdbUICtx.setPreviewing(false);
    }

    private String findNextIntoSolutionId() {
        IExtFilterSchemeProxy extFilterSchemeProxy = ProxyFactory.createExtFilterSchemeProxy((Object)((Object)this.ctx));
        List existSolutions = extFilterSchemeProxy.findAllFilterSchemes(this.getEditID(), 0);
        for (ExtFilterScheme extFilterScheme : existSolutions) {
            if (!extFilterScheme.isNextDirectlyInto() || !(extFilterScheme.getShareStrategy() == 1 ? StringUtil.equals((String)extFilterScheme.getOwnerId(), (String)this.ctx.getSeessionSQLDesignerProxy().getContext().getUserID()) : extFilterScheme.getShareStrategy() == 0)) continue;
            return extFilterScheme.getUuid();
        }
        return null;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceld = false;
        this.save(this.mapData);
    }

    @Override
    protected void btnSaveAs_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceld = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("leafParentTreePath", this.mapData.get("leafParentTreePath").toString());
        this.save(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(HashMap<String, Object> mapData) throws Exception {
        block16: {
            String fisdynamicsql;
            StringBuilder builder;
            String fname = CtrlReportUtil.getObjectString((Object)mapData.get("fname"));
            Map<String, String> mapName = null;
            String fid = CtrlReportUtil.getObjectString((Object)mapData.get("fid"));
            String systemID = CtrlReportUtil.getObjectString((Object)mapData.get("leafParentTreePath"));
            boolean isSQL = false;
            boolean isNoName = false;
            this._tdbUICtx.setPreviewing(false);
            if (!this._tc.finished()) {
                return;
            }
            Collection<Column> columns = OutputFieldsUI.getNameAlisaMapFromModel(this.getModel()).values();
            if (columns.size() > 0 && this.CheckAliasValid(builder = new StringBuilder(), columns).booleanValue()) {
                MessageUtil.showInfo(builder.toString(), false, "");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)fname)) {
                mapName = this.showNewNameUI(false);
                if (mapName == null) {
                    return;
                }
            } else {
                mapName = new HashMap<String, String>();
                mapName.put("l2", fname);
            }
            if ((fisdynamicsql = CtrlReportUtil.getObjectString((Object)mapData.get("fisdynamicsql"))).equals(QingRptLauncherMessages.getMLS("one", "1"))) {
                isSQL = true;
            }
            if (this.dataset != null) {
                String metaStr = this.getModelXml();
                this.dataset.setMeta(metaStr);
            } else {
                CtrlDesignOutputStream out = new CtrlDesignOutputStream((Object)this.ctx, mapName, fid, systemID, this.customType.intValue());
                try {
                    CtrlDesignCommonQuery commonQuery = this.model.getCommonQuery();
                    Map map = commonQuery.getProperties();
                    if (!mapName.isEmpty()) {
                        map.putAll(mapName);
                    }
                    RunReportParam.setSQLVersion((CtrlDesignQueryModel)this.model);
                    IQuery query = this.model.getQuery();
                    IXmlElement xml = CtrlDesignUtil.toXml((Object)((Object)this.ctx), (CtrlDesignCommonQuery)commonQuery, (IQuery)query);
                    XmlUtil.save((IXmlElement)xml, (OutputStream)out);
                    mapData.put("fid", out.getFid());
                    if (!isNoName) break block16;
                    Container obj = this.getParent();
                    while (true) {
                        if (obj instanceof JDialog) {
                            String message = QingRptLauncherMessages.getMLS("sqlDesigner", "SQL\u67e5\u8be2\u8bbe\u8ba1\u5668");
                            ((JDialog)obj).setTitle(message + " - " + fname);
                            break;
                        }
                        obj = ((Component)obj).getParent();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"\u4fdd\u5b58\u6570\u636e\u96c6\u51fa\u73b0\u5f02\u5e38", (Throwable)ex);
                    MessageUtil.showDetailAndOK(null, ex.getMessage(), ex);
                }
                finally {
                    StreamUtil.closeStream((OutputStream)out);
                }
            }
        }
        MessageUtil.showInfo(QingRptLauncherMessages.getMLS("success", "\u4fdd\u5b58\u6210\u529f"), false, "");
    }

    public String getMetaFolderId() {
        return this.ctx.getSeessionSQLDesignerProxy().getContext().getMetaFolderId();
    }

    @Override
    public boolean destroyWindow() {
        this.ctx.getSeessionSQLDesignerProxy().releaseLock();
        return true;
    }

    @Override
    public void handUIException(Throwable throwable) {
        MessageUtil.showDetailAndOK(null, QingRptLauncherMessages.getMLS("clientException", "\u5ba2\u6237\u7aef\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f"), (Exception)throwable);
    }

    @Override
    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
            this.kDTabbedPane1.setForcedHide(true);
        }
    }

    public CtrlDesignQueryModel getModel() {
        return this.model;
    }

    public void setModel(CtrlDesignQueryModel model) {
        this.model = model;
    }

    public HashMap<String, Object> getMapData() {
        return this.mapData;
    }

    public void setMapData(HashMap<String, Object> mapData) {
        this.mapData = mapData;
        this.customType = (SQLCustomType)mapData.get("customType");
    }

    public String getEditID() {
        return this.mapData == null ? "" : CtrlReportUtil.getObjectString((Object)this.mapData.get("fid"));
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isNoFoundQuery() {
        return this.isNoFoundQuery;
    }

    public SQLCustomType getCustomType() {
        return this.customType;
    }

    public void setDataset(ExtDataSet dataset) {
        this.dataset = dataset;
    }

    public boolean isCanceld() {
        return this.isCanceld;
    }

    private Map<String, String> showNewNameUI(boolean updateName) throws Exception {
        Map<String, String> mapName;
        block3: {
            String fname;
            String leafParentTreePath = CtrlReportUtil.getObjectString((Object)this.mapData.get("leafParentTreePath"));
            String fid = CtrlReportUtil.getObjectString((Object)this.mapData.get("fid"));
            String strLocal = new Locale("l2", "").toString();
            KSQLNameUI nameUI = new KSQLNameUI(this, leafParentTreePath);
            while (true) {
                nameUI.clear();
                ReportDialog.showDialog(nameUI, QingRptLauncherMessages.getMLS("save", "\u4fdd\u5b58"), true);
                if (!nameUI.isOk()) {
                    return null;
                }
                mapName = nameUI.getMapData();
                fname = CtrlReportUtil.getObjectString((Object)mapName.get(strLocal));
                String userId = this.ctx.getSeessionSQLDesignerProxy().getContext().getUserID();
                boolean flag = KSQLReportBO.isExitsName((Object)((Object)this.ctx), (String)userId, (String)leafParentTreePath, (String)fid, (String)fname);
                if (flag || fname.equals(CtrlReportUtil.getObjectString((Object)this.mapData.get("fname")))) {
                    MsgBox.showInfo(QingRptLauncherMessages.getMLS("reportNameRepeat", "\u540d\u79f0\u91cd\u590d"));
                    continue;
                }
                if (fname.length() <= 50) break;
                MsgBox.showInfo(QingRptLauncherMessages.getMLS("datasetNameCannotExceed50Chars", "\u6570\u636e\u96c6\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50\u4e2a\u5b57\u7b26\uff01"));
            }
            if (!updateName) break block3;
            this.mapData.put("fname", fname);
        }
        return mapName;
    }

    public Context getContext() {
        return this.ctx;
    }

    private Boolean CheckAliasValid(StringBuilder builder, Collection<Column> columns) {
        if (this.CheckAliasPatternValid(builder, columns).booleanValue()) {
            builder.append(QingRptLauncherMessages.getMLS("columnAliasRules", "\u5217\u522b\u540d\u53ea\u80fd\u7531\u6c49\u5b57\u3001\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\u4e14\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
            return true;
        }
        if (this.CheckRepeatAlias(builder, columns).booleanValue()) {
            builder.append(QingRptLauncherMessages.getMLS("duplicateColumnAliases", "\u591a\u4e2a\u5b57\u6bb5\u540d\u4e4b\u95f4\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u5217\u522b\u540d\u3002"));
            return true;
        }
        return false;
    }

    private Boolean CheckAliasPatternValid(StringBuilder builder, Collection<Column> columns) {
        boolean hasUnCorrectAlias = false;
        for (Column col : columns) {
            if (StringUtil.isEmptyString((String)col.getAlias())) {
                builder.append(QingRptLauncherMessages.getMLS("invalidColumnAliasEmpty", "{#1}\u7684\u5217\u522b\u540d\u7a7a\u5b57\u7b26\u4e32\uff0c\u4e0d\u89c4\u8303\uff1b\n").replace("#1", col.getName()));
                hasUnCorrectAlias = true;
                continue;
            }
            String alias = col.getAlias();
            if (this.customType == SQLCustomType.OQL) {
                alias = alias.replaceAll("\\.", "");
            }
            if (this.correctAliasPattern.matcher(alias).matches()) continue;
            builder.append(QingRptLauncherMessages.getMLS("invalidColumnAliasEmpty", "{#1}\u7684\u5217\u522b\u540d{#2}\u4e0d\u89c4\u8303\uff1b\n").replace("#1", col.getName()).replace("#2", col.getAlias()));
            hasUnCorrectAlias = true;
        }
        return hasUnCorrectAlias;
    }

    private Boolean CheckRepeatAlias(StringBuilder builder, Collection<Column> columns) {
        HashMap<String, String> map = new HashMap<String, String>();
        boolean hasRepeatAlias = false;
        for (Column col : columns) {
            if (map.containsKey(col.getAlias())) {
                builder.append(QingRptLauncherMessages.getMLS("duplicateColumnAlias", "{#1}\u7684\u5217\u522b\u540d{#2}\u4e0e\u5b57\u6bb5{#3}\u7684\u5217\u522b\u540d\u91cd\u590d\uff1b\n").replace("#1", col.getName()).replace("#2", col.getAlias()).replace("#3", (CharSequence)map.get(col.getAlias())));
                hasRepeatAlias = true;
                continue;
            }
            map.put(col.getAlias(), col.getName());
        }
        return hasRepeatAlias;
    }
}

