/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.boslayer.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.boslayer.eas.common.SubSystemUtils;
import com.kingdee.bos.boslayer.eas.util.client.MsgBox;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil2;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.AbstractKSQLNameUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DesignUI;
import com.kingdee.cosmic.ctrl.swing.MultiLangItem;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class KSQLNameUI
extends AbstractKSQLNameUI {
    private static final long serialVersionUID = -8244798888569913703L;
    private boolean isOk = false;
    private Map<String, String> mapData = new HashMap<String, String>();
    private DesignUI _designUI;
    private ArrayList<IBriefViewTreeNode> nodeList = new ArrayList();

    public KSQLNameUI(DesignUI designUI) throws Exception {
        this._designUI = designUI;
    }

    public KSQLNameUI(DesignUI designUI, String groupID) throws Exception {
        this(designUI);
        this.setDefalultListName();
        this.setTipSystemName(groupID);
    }

    private void setTipSystemName(String systemName) {
        MetaDataBriefInfo root = (MetaDataBriefInfo)SubSystemUtils.getSubSystemByName(this._designUI.getContext());
        this.buildRootName((IBriefViewTreeNode)root, systemName);
        systemName = "/" + root.getName();
        for (int i = this.nodeList.size() - 2; i >= 0; --i) {
            systemName = systemName + "/" + this.nodeList.get(i).getName();
        }
        this.kDTextField1.setText(systemName);
        this.kDTextField1.setToolTipText(systemName);
    }

    private boolean buildRootName(IBriefViewTreeNode root, String systemName) {
        if (root.getFullName().equals(systemName)) {
            this.nodeList.add(root);
            return true;
        }
        Enumeration children = root.children();
        if (children == null || !children.hasMoreElements()) {
            return false;
        }
        while (children.hasMoreElements()) {
            IBriefViewTreeNode next = (IBriefViewTreeNode)children.nextElement();
            if (!this.buildRootName(next, systemName)) continue;
            this.nodeList.add(next);
            return true;
        }
        return false;
    }

    private void setDefalultListName() {
        String strLocal = new Locale("l2", "").toString();
        int z = this.kDBizMultiLangBoxName.getItemCount();
        for (int i = 0; i < z; ++i) {
            MultiLangItem mli = (MultiLangItem)this.kDBizMultiLangBoxName.getItemAt(i);
            String ls = mli.getLang().getLocale().toString();
            if (!strLocal.equals(ls)) continue;
            this.kDBizMultiLangBoxName.setSelectedItem(mli);
        }
    }

    @Override
    protected void kDButtonOk_actionPerformed(ActionEvent e) throws Exception {
        this.mapData = CtrlReportUtil2.getEaslocaleFromKDMultiLangBox(this.kDBizMultiLangBoxName);
        boolean flag = false;
        boolean invalidNameFlag = false;
        boolean isKeywordsFlag = false;
        String keyworkds = "";
        String strLocal = new Locale("l2", "").toString();
        Iterator<String> it = this.mapData.keySet().iterator();
        while (it.hasNext()) {
            String strLocalTmp = it.next().toString();
            if (CtrlReportUtil.getObjectString((Object)this.mapData.get(strLocalTmp)).length() == 0 || !strLocalTmp.equals(strLocal)) continue;
            flag = true;
            if (!Pattern.matches("^([\u4e00-\u9fa5a-zA-Z_])[\u4e00-\u9fa5a-zA-Z0-9_]{0,}$", this.mapData.get(strLocalTmp))) {
                invalidNameFlag = true;
                break;
            }
            if (!Pattern.compile("\\b(null|true|false)\\b", 2).matcher(this.mapData.get(strLocalTmp)).find()) break;
            isKeywordsFlag = true;
            keyworkds = this.mapData.get(strLocalTmp);
            break;
        }
        if (!flag) {
            MsgBox.showInfo(QingRptLauncherMessages.getMLS("datasetName", "\u6570\u636e\u96c6\u540d\u79f0") + "(" + CtrlReportUtil.bosToEasLang((String)strLocal) + ")" + QingRptLauncherMessages.getMLS("cannotBeEmpty", "\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            this.kDBizMultiLangBoxName.requestFocus();
            return;
        }
        if (invalidNameFlag) {
            MsgBox.showInfo(QingRptLauncherMessages.getMLS("datasetNameOnlyContainCharsAndNumber", "\u6570\u636e\u96c6\u540d\u79f0\u53ea\u80fd\u7531\u6c49\u5b57\u3001\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff01"));
            this.kDBizMultiLangBoxName.requestFocus();
            return;
        }
        if (isKeywordsFlag) {
            MsgBox.showInfo(QingRptLauncherMessages.getMLS("unavailableName", "\u65e0\u6cd5\u4f7f\u7528\"#1\"\u4f5c\u4e3a\u540d\u79f0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002").replace("#1", keyworkds));
            this.kDBizMultiLangBoxName.requestFocus();
            return;
        }
        this.isOk = true;
        this.closeWin();
    }

    public Map<String, String> getMapData() {
        return this.mapData;
    }

    public void setMapData(HashMap<String, String> mapData) {
        this.mapData = mapData;
    }

    public void clear() {
        this.mapData.clear();
        this.isOk = false;
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isOk = false;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isOk() {
        return this.isOk;
    }

    public boolean isSQL() {
        return true;
    }
}

