/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.BaseTabUIImp;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DesignUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.OQLModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.cosmic.ctrl.common.layout.table2.CellOccupied;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.common.ui.editor.styled.ScriptQLStyledEditor;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import java.awt.Component;
import java.awt.LayoutManager;
import org.apache.log4j.Logger;

public class OqlUI
extends BaseTabUIImp {
    private static final Logger logger = Logger.getLogger(OqlUI.class);
    private CtrlDesignQueryModel model = null;
    private DesignUI _designUI;
    private ContentPane contentPane;

    public OqlUI(DesignUI designUI) {
        this._designUI = designUI;
        this.model = this._designUI.getModel();
        this.contentPane = new ContentPane();
    }

    public void refreshFromModel(boolean isRefreshFromModel) {
        this.setRefreshFromModel(isRefreshFromModel);
    }

    @Override
    public KDPanel getPanel() {
        return this.contentPane;
    }

    @Override
    public void syncUi2Model() {
        OQLModel oqLModel = this.model.getOqlModel();
        if (oqLModel == null) {
            oqLModel = new OQLModel();
            this.model.setOqlModel(oqLModel);
        }
        oqLModel.setContent(this.contentPane.getContent());
    }

    @Override
    public void syncModel2Ui() {
        if (this._designUI.isNoFoundQuery()) {
            this.contentPane.showValue(this.model.getOqlModel());
            return;
        }
        try {
            this.updateSQL();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            MessageUtil.showDetailAndOK(null, QingRptLauncherMessages.getMLS("failParseMetadata", "\u89e3\u6790\u5143\u6570\u636e\u9519\u8bef") + "\r\n" + e.getMessage(), (Exception)((Object)e));
            return;
        }
        this.contentPane.showValue(this.model.getOqlModel());
    }

    private void updateSQL() throws BOSException {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)this.model.getQuery();
        if (ksqlQuery.isRegular()) {
            String sql = CtrlDesignQueryModel.makeSQL((CtrlDesignQueryModel)this.model);
            this.model.getQuery().setContent(sql);
        }
    }

    static class ContentPane
    extends KDPanel {
        private static final long serialVersionUID = -9018141010951919050L;
        private ScriptQLStyledEditor editor;

        public ContentPane() {
            this.init();
        }

        private void init() {
            this.setOpaque(false);
            this.editor = new ScriptQLStyledEditor();
            KDScrollPane scpEditor = new KDScrollPane();
            scpEditor.setBorder(this.editor.getBorder());
            this.editor.setBorder(null);
            scpEditor.getViewport().add((Component)this.editor);
            TableLayout2 ly = new TableLayout2(2, 3);
            ly.setFixedHeight(0, 20);
            ly.setRowSpacing(0, 3);
            ly.setRatableHeight(1, 1);
            ly.setRatableWidth(0, 40);
            ly.setRatableWidth(1, 320);
            ly.setFixedWidth(2, 100);
            ly.setColsSpacing(TableLayout2.ALL, 4);
            this.setLayout((LayoutManager)ly);
            this.add((Component)scpEditor, new CellOccupied(1, 0, 1, 2));
        }

        private void setContent(String str) {
            this.editor.setText(str);
            this.editor.setCaretPosition(0);
        }

        private String getContent() {
            return this.editor.getText();
        }

        public void showValue(OQLModel oqlModel) {
            if (oqlModel != null) {
                String queryContent = oqlModel.getContent();
                this.setContent(queryContent);
            }
        }
    }
}

