/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.boslayer.bos.ui.face.CoreUIObject;
import com.kingdee.bos.boslayer.eas.util.client.MsgBox;
import com.kingdee.bos.corelayer.ISQLDesignerContext;
import com.kingdee.bos.corelayer.proxy.IBizCloudProxy;
import com.kingdee.bos.corelayer.proxy.ISQLDesignerProxy;
import com.kingdee.bos.corelayer.proxy.ProxyFactory;
import com.kingdee.bos.datawizard.edd.ctrlreport.app.CtrlDBUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.ExtReportOutDBBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.client.ReportDialog;
import com.kingdee.bos.datawizard.edd.ctrlreport.client.app.AppSelectUI;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.AbstractOutDBUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.util.TableUIUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignDataSourceType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.bos.report.ds.vo.DesignerVO;
import com.kingdee.cosmic.ctrl.common.datacenter.DataCenterDBType;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.event.SelectorEvent;
import com.kingdee.cosmic.ctrl.swing.event.SelectorListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class OutDBUI
extends AbstractOutDBUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(OutDBUI.class);
    private transient List outDBList = null;
    private Color colorOld = null;
    private String outDBName = "";
    private Context ctx;
    private transient CtrlDesignQueryModel model;
    private transient ISQLDesignerProxy sqlDesignerProxy;
    private transient IBizCloudProxy bizCloudProxy;

    private ISQLDesignerProxy getSqlDesignerProxy() {
        if (this.sqlDesignerProxy == null) {
            this.sqlDesignerProxy = ProxyFactory.createSQLDesignerProxy((Object)((Object)this.ctx));
        }
        return this.sqlDesignerProxy;
    }

    private IBizCloudProxy getBizCloudProxy() {
        if (this.bizCloudProxy == null) {
            this.bizCloudProxy = ProxyFactory.createBizCloudProxy((Object)((Object)this.ctx));
        }
        return this.bizCloudProxy;
    }

    public OutDBUI(Context ctx, CtrlDesignQueryModel model) throws Exception {
        this.ctx = ctx;
        this.model = model;
        this.init();
    }

    @Override
    protected void fireDbTypeChanged() {
        this.clearPublicDbChecked();
        this.clearDataCenterChecked();
        this.clearSuperQueryChecked();
        super.fireDbTypeChanged();
    }

    private void init() {
        this.initLayout();
        this.setOpaque(false);
        this.initSuperQuerySchema();
        this.initTable();
        boolean permission = this.getSqlDesignerProxy().checkDBCenterPermission();
        this.setDataCenterPermission(permission);
        this.initOutDBList(false);
        this.installListener();
    }

    private void initTable() {
        this.table.checkParsed();
        this.table.getSelectManager().setSelectMode(2);
        InputMap inputMap = this.table.getInputMap();
        inputMap.remove(KeyStroke.getKeyStroke(38, 64));
        inputMap.remove(KeyStroke.getKeyStroke(40, 64));
        TableUIUtil.setColumnsNonEditable(this.table, 1);
        IColumn useColumn = this.table.getColumn(0);
        KDCheckBox useCheckBox = new KDCheckBox();
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JCheckBox)useCheckBox);
        useCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String outDBCheck;
                KDCheckBox checkBox = (KDCheckBox)e.getSource();
                boolean selected = checkBox.isSelected();
                KDTSelectManager selectManager = OutDBUI.this.table.getSelectManager();
                int activeRowIndex = selectManager.getActiveRowIndex();
                IRow row = OutDBUI.this.table.getRow(activeRowIndex);
                HashMap mapData = (HashMap)row.getUserObject();
                String dbCenterName = CtrlReportUtil.getObjectString(mapData.get("dbcentername"));
                if (!CtrlDBUtil.isSuperQuerySource((String)dbCenterName) && (outDBCheck = OutDBUI.this.checkOutDataSource(dbCenterName)) != null) {
                    MessageUtil.showInfo(outDBCheck, false, "");
                }
                OutDBUI.this.clearPublicDbChecked();
                OutDBUI.this.setDbType(CtrlDesignDataSourceType.PUBLIC_DB);
                OutDBUI.this.rowHighLight(row, selected);
                int iDbType = Integer.parseInt(CtrlReportUtil.getObjectString(mapData.get("dbtype")));
                if (iDbType == -10) {
                    dbCenterName = CtrlDBUtil.getRealUserSuperQueryName((String)dbCenterName);
                }
                OutDBUI.this.setOutDBName(dbCenterName);
                String errorText = OutDBUI.this.labelErr.getText();
                errorText = errorText.trim();
                if (!StringUtils.isEmpty((CharSequence)errorText)) {
                    OutDBUI.this.showError("");
                }
            }
        });
        useColumn.setEditor((ICellEditor)kdtDefaultCellEditor);
    }

    private void initSuperQuerySchema() {
        SwingWorker<List<String>, Object> worker = new SwingWorker<List<String>, Object>(){
            private List<String> superQuerySchemas = null;

            @Override
            protected List<String> doInBackground() throws Exception {
                try {
                    this.superQuerySchemas = ExtReportOutDBBO.getSuperQuerySchemas((Object)((Object)OutDBUI.this.ctx));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.superQuerySchemas;
            }

            @Override
            protected void done() {
                OutDBUI.this.superQueryComboBox.removeAllItems();
                OutDBUI.this.superQueryComboBox.setEnabled(true);
                if (OutDBUI.this.dbType == CtrlDesignDataSourceType.SYS_SUPER_QUERY.type() && CtrlDBUtil.isSysSuperQuerySource((String)OutDBUI.this.outDBName)) {
                    CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)OutDBUI.this.model.getQuery();
                    String outDB = CtrlReportUtil.getObjectString((Object)ksqlQuery.getOutDB());
                    if (this.superQuerySchemas == null || this.superQuerySchemas.isEmpty()) {
                        OutDBUI.this.setOutDBName(null);
                    } else {
                        OutDBUI.this.superQueryComboBox.addItems(this.superQuerySchemas.toArray(), false);
                        OutDBUI.this.superQueryComboBox.setSelectedIndex(-1);
                    }
                    OutDBUI.this.superQueryComboBox.setSelectedItem((Object)CtrlDBUtil.getDisSysSuperQueryName((String)outDB));
                    if (OutDBUI.this.superQueryComboBox.getSelectedIndex() == -1) {
                        OutDBUI.this.showError(QingRptLauncherMessages.getMLS("hasBeenDeletedOrRevokedAuthorizationInSuperQuery", "\u5f53\u524d\u4f7f\u7528\u7684\u6570\u636e\u6e90\"#1\"\u5df2\u5728\"\u8d85\u7ea7\u67e5\u8be2\"\u4e2d\u5220\u9664\u6216\u53d6\u6d88\u6388\u6743\u7ed9\u60a8, \u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002").replace("#1", CtrlDBUtil.getDisSysSuperQueryName((String)outDB)));
                        OutDBUI.this.setOutDBName(null);
                    }
                } else {
                    if (this.superQuerySchemas != null) {
                        OutDBUI.this.superQueryComboBox.addItems(this.superQuerySchemas.toArray(), false);
                    }
                    OutDBUI.this.superQueryComboBox.setSelectedIndex(-1);
                }
                if (this.superQuerySchemas == null || this.superQuerySchemas.isEmpty()) {
                    OutDBUI.this.superQueryComboBox.addItem((Object)QingRptLauncherMessages.getMLS("noAvailableModels", "\u6ca1\u6709\u53ef\u7528\u7684\u6a21\u5f0f"), false);
                    OutDBUI.this.superQueryComboBox.setSelectedIndex(0, false);
                    OutDBUI.this.superQueryComboBox.setEnabled(false);
                }
            }
        };
        this.superQueryComboBox.addItem((Object)QingRptLauncherMessages.getMLS("loading", "\u52a0\u8f7d\u4e2d..."), false);
        this.superQueryComboBox.setSelectedIndex(0, false);
        this.superQueryComboBox.setEnabled(false);
        worker.execute();
    }

    private void clearPublicDbChecked() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            this.rowHighLight(row, false);
            ICell cell = row.getCell(0);
            cell.setValue((Object)Boolean.FALSE);
        }
        if (this.dbType != CtrlDesignDataSourceType.PUBLIC_DB.type()) {
            this.setOutDBName("");
        }
        if (!"".equals(this.labelErr.getText())) {
            this.showError("");
        }
    }

    private void clearDataCenterChecked() {
        if (this.dbType != CtrlDesignDataSourceType.DATA_CENTER.type()) {
            this.appPromptBox.setText("");
            this.setOutDBName("");
        }
    }

    private void clearSuperQueryChecked() {
        if (this.dbType != CtrlDesignDataSourceType.SYS_SUPER_QUERY.type()) {
            if (this.superQueryComboBox.isEnabled()) {
                this.superQueryComboBox.setSelectedIndex(-1);
            }
            this.setOutDBName("");
        }
    }

    private void installListener() {
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutDBUI.this.beforeActionPerformed(e);
                try {
                    OutDBUI.this.initOutDBList(true);
                }
                catch (Exception exc) {
                    OutDBUI.this.handUIException(exc);
                }
                finally {
                    OutDBUI.this.afterActionPerformed(e);
                }
            }
        });
        this.radioBtnDataCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutDBUI.this.beforeActionPerformed(e);
                try {
                    OutDBUI.this.setDbType(CtrlDesignDataSourceType.DATA_CENTER);
                }
                finally {
                    OutDBUI.this.afterActionPerformed(e);
                }
            }
        });
        this.radioBtnSuperQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutDBUI.this.beforeActionPerformed(e);
                try {
                    OutDBUI.this.setDbType(CtrlDesignDataSourceType.SYS_SUPER_QUERY);
                }
                finally {
                    OutDBUI.this.afterActionPerformed(e);
                }
            }
        });
        this.radioBtnPublicDb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutDBUI.this.beforeActionPerformed(e);
                try {
                    OutDBUI.this.setDbType(CtrlDesignDataSourceType.PUBLIC_DB);
                }
                finally {
                    OutDBUI.this.afterActionPerformed(e);
                }
            }
        });
        this.appPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                OutDBUI.this.appPromptBoxAction();
            }
        });
        this.superQueryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = ((KDComboBox)e.getSource()).getSelectedItem();
                if (selectedItem == null) {
                    return;
                }
                OutDBUI.this.setDbType(CtrlDesignDataSourceType.SYS_SUPER_QUERY);
                OutDBUI.this.setOutDBName(CtrlDBUtil.getRealSysSuperQueryName((String)((String)selectedItem)));
                String errorText = OutDBUI.this.labelErr.getText();
                if (!StringUtils.isEmpty((CharSequence)errorText)) {
                    OutDBUI.this.showError("");
                }
            }
        });
    }

    private void appPromptBoxAction() {
        try {
            String selectedAppNumber;
            AppSelectUI appSelectUI = new AppSelectUI(this.ctx);
            if (this.radioBtnDataCenter.isSelected() && !StringUtils.isEmpty((CharSequence)this.outDBName) && CtrlDBUtil.isDataCenterName((String)this.outDBName)) {
                selectedAppNumber = this.getAppNameByDataCenterName();
                DesignerVO selectedAppInfo = new DesignerVO(4);
                selectedAppInfo.addColumn("number", (Object)selectedAppNumber);
                appSelectUI.setSelectedInfo(selectedAppInfo, true);
            }
            appSelectUI.init();
            ReportDialog.showDialog(appSelectUI, QingRptLauncherMessages.getMLS("applicationSelection", "\u5e94\u7528\u9009\u62e9"), true);
            if (appSelectUI.isOk()) {
                selectedAppNumber = appSelectUI.getSelectedAppNumber();
                String selectedAppName = appSelectUI.getSelectedAppName();
                if (StringUtils.isEmpty((CharSequence)selectedAppName) || StringUtils.isEmpty((CharSequence)selectedAppNumber)) {
                    MsgBox.showInfo(QingRptLauncherMessages.getMLS("selectRecord", "\u8bf7\u9009\u62e9\u8bb0\u5f55\uff01"));
                } else {
                    this.appPromptBox.setText(selectedAppName);
                    this.setDbType(CtrlDesignDataSourceType.DATA_CENTER);
                    this.setOutDBName(this.getDataCenterName(selectedAppNumber));
                }
            }
        }
        catch (IOException ex) {
            logger.error((Object)"\u627e\u4e0d\u5230\u8d44\u6e90\u7c7b\uff1aAppSelectUI", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            logger.error((Object)"\u627e\u4e0d\u5230\u8d44\u6e90\u7c7b\uff1aAppSelectUI", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)"\u521b\u5efa\u5e94\u7528\u9009\u62e9\u5f39\u6846\u51fa\u9519", (Throwable)ex);
        }
    }

    private void initOutDBList(boolean isRefresh) {
        if (this.outDBList == null || isRefresh) {
            try {
                this.outDBList = ExtReportOutDBBO.getDBList((Object)((Object)this.ctx));
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.outDBList = new ArrayList();
            }
        }
        this.refreshUI();
    }

    private void refreshUI() {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)this.model.getQuery();
        String outDB = CtrlReportUtil.getObjectString((Object)ksqlQuery.getOutDB());
        if (CtrlDBUtil.isDataCenterName((String)outDB)) {
            this.setDbType(CtrlDesignDataSourceType.DATA_CENTER);
        } else if (CtrlDBUtil.isSysSuperQuerySource((String)outDB)) {
            this.setDbType(CtrlDesignDataSourceType.SYS_SUPER_QUERY);
        } else {
            this.setDbType(CtrlDesignDataSourceType.PUBLIC_DB);
        }
        this.setOutDBName(outDB);
        this.table.removeRows();
        boolean isFoundSelected = false;
        for (HashMap map : this.outDBList) {
            boolean selected;
            IRow row = this.table.addRow();
            String fDbCenterName = CtrlReportUtil.getObjectString(map.get("dbcentername"));
            ICell useCell = row.getCell(0);
            row.getCell(1).setValue((Object)CtrlDBUtil.getDisUserSuperQueryName((String)fDbCenterName));
            int iDbType = Integer.parseInt(CtrlReportUtil.getObjectString(map.get("dbtype")));
            row.getCell(2).setValue((Object)DataCenterDBType.getDBType((int)iDbType));
            row.getCell(3).setValue((Object)CtrlReportUtil.getObjectString(map.get("address")));
            row.getCell(4).setValue((Object)CtrlReportUtil.getObjectString(map.get("username")));
            this.setCellsNonEditable(row, 1);
            row.setUserObject((Object)map);
            boolean bl = selected = !StringUtils.isEmpty((CharSequence)outDB) && fDbCenterName.equals(CtrlDBUtil.getDisUserSuperQueryName((String)outDB));
            if (selected) {
                isFoundSelected = true;
            }
            useCell.setValue((Object)selected);
            this.rowHighLight(row, selected);
        }
        String errText = "";
        if (this.dbType == CtrlDesignDataSourceType.DATA_CENTER.type() && CtrlDBUtil.isDataCenterName((String)this.outDBName)) {
            String appNumber = this.getAppNameByDataCenterName();
            String appName = this.getBizCloudProxy().getAppName(appNumber);
            if (StringUtil.isEmptyString((String)appName)) {
                errText = QingRptLauncherMessages.getMLS("selectedCurrentDataCenterDoesNotExist", "\u9009\u4e2d\u7684\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e0d\u5b58\u5728");
            }
            this.appPromptBox.setText(StringUtil.isEmptyString((String)appName) ? appNumber : appName);
        } else if (this.dbType == CtrlDesignDataSourceType.SYS_SUPER_QUERY.type() && CtrlDBUtil.isSysSuperQuerySource((String)this.outDBName)) {
            this.superQueryComboBox.setSelectedItem((Object)CtrlDBUtil.getDisSysSuperQueryName((String)outDB));
            if (this.superQueryComboBox.getSelectedIndex() == -1) {
                errText = QingRptLauncherMessages.getMLS("hasBeenDeletedOrRevokedAuthorizationInSuperQuery", "\u5f53\u524d\u4f7f\u7528\u7684\u6570\u636e\u6e90\"#1\"\u5df2\u5728\"\u8d85\u7ea7\u67e5\u8be2\"\u4e2d\u5220\u9664\u6216\u53d6\u6d88\u6388\u6743\u7ed9\u60a8, \u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002").replace("#1", CtrlDBUtil.getDisSysSuperQueryName((String)outDB));
                this.setOutDBName(null);
            }
        }
        if (this.dbType == CtrlDesignDataSourceType.PUBLIC_DB.type() && !isFoundSelected && !StringUtils.isEmpty((CharSequence)outDB)) {
            errText = QingRptLauncherMessages.getMLS("hasBeenDeletedOrRevokedAuthorizationInPublicDataSource", "\u5f53\u524d\u4f7f\u7528\u7684\u6570\u636e\u6e90\"#1\"\u5df2\u5728\"\u516c\u5171\u6570\u636e\u6e90\"\u4e2d\u5220\u9664\u6216\u53d6\u6d88\u6388\u6743\u7ed9\u60a8, \u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002").replace("#1", CtrlDBUtil.getDisUserSuperQueryName((String)outDB));
            this.setOutDBName(null);
        } else if (this.dbType == CtrlDesignDataSourceType.DATA_CENTER.type() && !this.hasDataCenterPermission) {
            errText = QingRptLauncherMessages.getMLS("noPermissionForCurrentDataCenter", "\u6ca1\u6709\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u7684\u6743\u9650");
            this.setOutDBName(null);
        }
        if (this.hasDataCenterPermission && this.ctx.getSeessionSQLDesignerProxy().getContext().getPreset()) {
            this.labelErr.setForeground(Color.BLUE);
            errText = QingRptLauncherMessages.getMLS("presetDataSetDoesNotAllowSaveOrSaveAs", "\u63d0\u793a\uff1a\u9884\u7f6e\u7684\u6570\u636e\u96c6\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3001\u53e6\u5b58\u4e3a\u7b49\u64cd\u4f5c\uff0c\u5982\u6709\u9700\u8981\uff0c\u53ef\u590d\u5236\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002");
        }
        this.showError(errText);
    }

    private void setCellsNonEditable(IRow row, int startCol) {
        for (int i = startCol; i < this.table.getColumnCount(); ++i) {
            ICell cell = row.getCell(i);
            StyleAttributes sAttrs = cell.getStyleAttributes();
            sAttrs.setLocked(true);
        }
    }

    private void rowHighLight(IRow row, boolean isOpen) {
        StyleAttributes rowSAttrs = row.getStyleAttributes();
        if (isOpen) {
            this.colorOld = this.colorOld == null ? rowSAttrs.getFontColor() : this.colorOld;
            rowSAttrs.setFontColor(Color.blue);
        } else if (this.colorOld != null) {
            rowSAttrs.setFontColor(this.colorOld);
        }
        rowSAttrs.setBold(isOpen);
    }

    public String isOutDBNameError() {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)this.model.getQuery();
        String outDB = CtrlReportUtil.getObjectString((Object)ksqlQuery.getOutDB());
        if (StringUtils.isEmpty((CharSequence)outDB)) {
            return QingRptLauncherMessages.getMLS("currentDataSetSelectedDataSourceIsEmpty", "\u5f53\u524d\u6570\u636e\u96c6\u9009\u62e9\u7684\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u8bf7\u624b\u52a8\u9009\u62e9\u4e00\u4e2a");
        }
        return null;
    }

    public String checkPermission() {
        String outDBCheck;
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)this.model.getQuery();
        String outDB = CtrlReportUtil.getObjectString((Object)ksqlQuery.getOutDB());
        if (this.dbType == CtrlDesignDataSourceType.DATA_CENTER.type()) {
            if (!this.getSqlDesignerProxy().checkDBCenterPermission()) {
                return QingRptLauncherMessages.getMLS("noPermissionForCurrentDataCenter", "\u6ca1\u6709\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u7684\u6743\u9650");
            }
        } else if (this.dbType == CtrlDesignDataSourceType.PUBLIC_DB.type() && !CtrlDBUtil.isSuperQuerySource((String)outDB) && !StringUtil.isEmptyString((String)(outDBCheck = this.checkOutDataSource(outDB)))) {
            return outDBCheck;
        }
        return null;
    }

    private void setOutDBName(String outDBName) {
        this.outDBName = outDBName;
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)this.model.getQuery();
        ksqlQuery.setOutDB(this.outDBName);
    }

    private String getAppNameByDataCenterName() {
        String appNameSource = this.outDBName.substring("datacenter_".length());
        return appNameSource.trim();
    }

    private String getDataCenterName(String appNumber) {
        return "datacenter_" + appNumber;
    }

    private String checkOutDataSource(String outDB) {
        ISQLDesignerContext context = this.ctx.getSeessionSQLDesignerProxy().getContext();
        if (context != null) {
            String createrId;
            if (context.getPreset()) {
                createrId = context.getUserID();
            } else {
                String dataSetId = context.getDataSourceId();
                createrId = ExtReportOutDBBO.loadDataSetCreatorIdById((Object)((Object)this.ctx), (String)dataSetId);
            }
            int result = ExtReportOutDBBO.checkDataSourceTouchable((Object)((Object)this.ctx), (String)createrId, (String)outDB);
            if (result == 8099002) {
                return QingRptLauncherMessages.getMLS("hasBeenDeletedInPublicDataSource", "\u6570\u636e\u6e90\"#1\"\u5df2\u5728\"\u516c\u5171\u6570\u636e\u6e90\"\u4e2d\u5220\u9664, \u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002").replace("#1", outDB);
            }
            if (result == 8099007) {
                return QingRptLauncherMessages.getMLS("hasBeenRevokedAuthorizationInPublicDataSource", "\u6570\u636e\u6e90\"#1\"\u5df2\u5728\"\u516c\u5171\u6570\u636e\u6e90\"\u4e2d\u53d6\u6d88\u6388\u6743\u7ed9\u60a8, \u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002").replace("#1", outDB);
            }
        }
        return null;
    }
}

