/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.BaseTabUIImp;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DesignUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.ctrl_datawizard.PKIncludedTablePanel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.bos.report.ext.model.SQLCustomType;
import com.kingdee.cosmic.ctrl.common.DataType;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import com.kingdee.cosmic.ctrl.data.modal.Outputs;
import com.kingdee.cosmic.ctrl.data.modal.query.Column;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.cosmic.ctrl.data.modal.query.QueryType;
import com.kingdee.cosmic.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.kdf.util.editor.MultiLangItemList;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.MultiLangItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class OutputFieldsUI
extends BaseTabUIImp {
    private static final Logger log = LogUtil.getPackageLogger(OutputFieldsUI.class);
    private WizardPanel wizardPanel;
    private CtrlDesignQueryModel model = null;
    private String errMsg = null;
    private SQLCustomType _type;
    private DesignUI _designUI;

    public OutputFieldsUI(DesignUI designUI) {
        this._designUI = designUI;
        this._type = this._designUI.getCustomType();
        this.model = this._designUI.getModel();
        this.wizardPanel = new WizardPanel();
    }

    @Override
    public KDPanel getPanel() {
        return this.wizardPanel;
    }

    @Override
    public void syncModel2Ui() {
        Outputs outputs = this.model.getCommonQuery().getOutputs();
        if (outputs != null && outputs.size() > 0) {
            this.wizardPanel.fieldsPanel.setFields((List)outputs.get(0));
        }
        this.wizardPanel.setDynamicField(new Boolean(CtrlReportUtil.getObjectString((Object)this.model.getCommonQuery().getProperty(CtrlDesignUtil.isDynamicField))));
    }

    @Override
    public void syncUi2Model() {
        IQuery quer;
        Outputs outputs = this.model.getCommonQuery().getOutputs();
        if (outputs == null) {
            outputs = new Outputs();
            this.model.getCommonQuery().setOutputs(outputs);
        }
        boolean isProcedure = false;
        SQLCustomType type = this._type;
        if (!type.equals(SQLCustomType.SQL) && type != SQLCustomType.SEMANTIC_SQL) {
            isProcedure = true;
        }
        if ((quer = this.model.getQuery()).getQueryType() == QueryType.SQL_CUSTOM || isProcedure) {
            outputs.clear();
            outputs.add((Object)this.wizardPanel.fieldsPanel.getFields());
        }
        CtrlDesignCommonQuery commonQuery = this.model.getCommonQuery();
        Map map = commonQuery.getProperties();
        map.put(CtrlDesignUtil.isDynamicField, String.valueOf(this.wizardPanel.isDynamicField()));
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public static final void getMultiLangItemListFromCell(ICell cell, DefObj def, String keyName) {
        MultiLangItemList itemList = (MultiLangItemList)cell.getValue();
        if (itemList != null) {
            Map properties = def.getProperties();
            MultiLangItem[] items = itemList.getItems();
            for (int n = 0; n < items.length; ++n) {
                MultiLangItem mli = items[n];
                String val = CtrlReportUtil.getObjectString((Object)mli.getData());
                String localString = CtrlReportUtil.bosToEasLang((String)mli.getLang().getLocale().toString());
                properties.put(keyName + "." + localString, val);
            }
            properties.put(keyName, "#1");
        }
    }

    public static final void setMultiLangItemListToCell(ICell cell, DefObj def, KDBizMultiLangBox bmlbAlias, String keyName) {
        int icount = bmlbAlias.getItemCount();
        MultiLangItem[] items = new MultiLangItem[icount];
        for (int m = 0; m < icount; ++m) {
            MultiLangItem mli = (MultiLangItem)bmlbAlias.getItemAt(m);
            Locale l = mli.getLang().getLocale();
            String localString = CtrlReportUtil.bosToEasLang((String)l.toString());
            Map properties = def.getProperties();
            String currentName = CtrlReportUtil.getObjectString(properties.get(keyName + "." + localString));
            items[m] = new MultiLangItem(mli.getLang(), (Object)currentName);
        }
        String strLocal = new Locale("l2", "").toString().toUpperCase();
        MultiLangItemList itemList = new MultiLangItemList(items);
        for (int n = 0; n < items.length; ++n) {
            MultiLangItem mli = items[n];
            String currentLocalString = mli.getLang().getLocale().toString();
            if (!currentLocalString.equalsIgnoreCase(strLocal)) continue;
            itemList.setCurrentItem(mli);
            break;
        }
        cell.setValue((Object)itemList);
    }

    public static Map<String, Column> getNameAlisaMapFromModel(CtrlDesignQueryModel model) {
        HashMap<String, Column> map = new HashMap<String, Column>();
        if (model != null) {
            Outputs outputs = model.getCommonQuery().getOutputs();
            OutputColumns ocs = null;
            if (outputs != null && !outputs.isEmpty()) {
                ocs = (OutputColumns)outputs.get(0);
                for (int i = 0; i < ocs.size(); ++i) {
                    Column oc = (Column)ocs.get(i);
                    map.put(oc.getName().toUpperCase(), oc);
                }
            }
        }
        return map;
    }

    public static class OutputFieldsPanel
    extends PKIncludedTablePanel {
        private static final long serialVersionUID = 8779079108460391930L;
        private static int COL_NAME = 0;
        public static int COL_ALIAS = 1;
        private static int COL_DATA_TYPE = 2;
        protected List externalPs;
        protected List externalEnv;
        protected List readOnlyColumns;
        protected KDBizMultiLangBox bmlbAlias;
        private OutputFieldsUI _ui;

        public OutputFieldsPanel(OutputFieldsUI ui) {
            super(0, true);
            this._ui = ui;
            this.initTable();
        }

        private void initTable() {
            this.table.addColumns(4);
            IRow headRow = this.table.addHeadRow();
            headRow.getCell(COL_NAME).setValue((Object)QingRptLauncherMessages.getMLS("fieldName", "\u5b57\u6bb5\u540d"));
            headRow.getCell(COL_ALIAS).setValue((Object)QingRptLauncherMessages.getMLS("alias", "\u522b\u540d"));
            headRow.getCell(COL_DATA_TYPE).setValue((Object)QingRptLauncherMessages.getMLS("type", "\u7c7b\u578b"));
            this.table.getColumn(COL_NAME).setWidth(150);
            this.table.getColumn(COL_ALIAS).setWidth(220);
            this.table.getColumn(COL_DATA_TYPE).setWidth(80);
            this.bmlbAlias = new KDBizMultiLangBox();
            if (this._ui._type == SQLCustomType.OQL) {
                this.bmlbAlias.setMaxLength(-1);
            } else {
                this.bmlbAlias.setMaxLength(32);
            }
            this.table.getColumn(COL_ALIAS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)((Object)this.bmlbAlias)));
            this.bmlbAlias.putClientProperty("All_Modal", Boolean.TRUE);
            this.table.getColumn(COL_NAME).getStyleAttributes().setLocked(true);
            this.table.getColumn(COL_DATA_TYPE).getStyleAttributes().setLocked(true);
            this.table.getColumn(COL_NAME).getStyleAttributes().setFontColor(Color.GRAY);
            this.table.getColumn(COL_DATA_TYPE).getStyleAttributes().setFontColor(Color.GRAY);
            this.setPkColumn(COL_NAME);
            this.table.getSelectManager().setSelectMode(1);
        }

        public void setFields(List ocs) {
            QueryType queryType = this._ui.model.getQuery().getQueryType();
            boolean isProcedure = false;
            SQLCustomType type = this._ui._type;
            if (!type.equals(SQLCustomType.SQL)) {
                isProcedure = true;
            }
            if (queryType == QueryType.SQL_WIZARD && !isProcedure) {
                this.table.getColumn(COL_ALIAS).getStyleAttributes().setLocked(true);
                this.table.getColumn(COL_ALIAS).getStyleAttributes().setFontColor(Color.GRAY);
            } else {
                this.table.getColumn(COL_ALIAS).getStyleAttributes().setLocked(false);
                this.table.getColumn(COL_ALIAS).getStyleAttributes().setFontColor(Color.BLACK);
            }
            this.table.removeRows();
            this.readOnlyColumns = new ArrayList();
            for (int i = 0; i < ocs.size(); ++i) {
                Column oc = (Column)ocs.get(i);
                IRow newRow = this.table.addRow();
                newRow.getCell(COL_NAME).setValue((Object)oc.getName());
                newRow.getCell(COL_ALIAS).setValue((Object)oc.getAlias());
                newRow.getCell(COL_DATA_TYPE).setValue((Object)oc.getDataType());
                if (queryType != QueryType.SQL_CUSTOM && !isProcedure) continue;
                OutputFieldsUI.setMultiLangItemListToCell(newRow.getCell(COL_ALIAS), (DefObj)oc, this.bmlbAlias, "alias");
            }
            if (this.table.getRowCount() > 0) {
                this.table.getEditManager().editCellAt(0, 1);
            }
        }

        public OutputColumns getFields() {
            OutputColumns list = new OutputColumns();
            int rows = this.table.getRowCount();
            for (int i = 0; i < rows; ++i) {
                IRow row = this.table.getRow(i);
                Column oc = new Column();
                oc.setName((String)row.getCell(COL_NAME).getValue());
                oc.setDataType((DataType)row.getCell(COL_DATA_TYPE).getValue());
                OutputFieldsUI.getMultiLangItemListFromCell(row.getCell(COL_ALIAS), (DefObj)oc, "alias");
                list.add((Object)oc);
            }
            return list;
        }
    }

    class WizardPanel
    extends KDPanel {
        private static final long serialVersionUID = -7629640026263253278L;
        private OutputFieldsPanel fieldsPanel;
        KDCheckBox cbDynamic;

        public WizardPanel() {
            this.fieldsPanel = new OutputFieldsPanel(OutputFieldsUI.this);
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.fieldsPanel), "Center");
            KDPanel panel = new KDPanel();
            panel.setLayout((LayoutManager)new FlowLayout(0));
            KDLabel lbMsg = new KDLabel(QingRptLauncherMessages.getMLS("previewAutoRefreshesOutputFields", "\u63d0\u793a\uff1a\u9884\u89c8\u540e\u81ea\u52a8\u5237\u65b0\u8f93\u51fa\u5b57\u6bb5"));
            lbMsg.setPreferredSize(new Dimension(280, 19));
            lbMsg.setForeground(new Color(0, 0, 255));
            panel.add((Component)lbMsg);
            this.cbDynamic = new KDCheckBox();
            this.cbDynamic.setText(QingRptLauncherMessages.getMLS("isDynamicOutputField", "\u662f\u5426\u52a8\u6001\u8f93\u51fa\u5b57\u6bb5\uff08\u8f93\u51fa\u5b57\u6bb5\u968f\u8fc7\u6ee4\u6761\u4ef6\u52a8\u6001\u53d8\u5316\uff0c\u52fe\u9009\u65f6\uff0c\u5b57\u6bb5\u7684\u522b\u540d\u5c31\u662f\u5b57\u6bb5\u540d\uff09"));
            this.cbDynamic.setPreferredSize(new Dimension(550, 19));
            this.add((Component)panel, "South");
        }

        public KDTable getTable() {
            return this.fieldsPanel.getTable();
        }

        public void setDynamicField(boolean dynamicField) {
            this.cbDynamic.setSelected(dynamicField);
        }

        public boolean isDynamicField() {
            return this.cbDynamic.isSelected();
        }
    }
}

