/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.pd;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.boslayer.eas.framework.client.CoreUI;
import com.kingdee.bos.boslayer.eas.util.client.MsgBox;
import com.kingdee.bos.datawizard.edd.ctrlreport.IPopupSelector;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exec.ExtRptMacroExecuteFacade;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroVO;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroValueType;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.ui.IExtRptMacroFilter;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.ui.IExtRptMacroSelectionAware;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.ui.action.ExtRptMacroManageActionFactory;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.ui.action.IExtRptMacroActionHost;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.MacroUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SystemMacroSelectedUI
extends KDPanel
implements IPopupSelector,
IExtRptMacroActionHost {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ExtRptMacroExecuteFacade.class);
    private KDToolBar toolBar;
    private KDButton btnConfirm;
    private KDButton btnCancel;
    private KDTable macroTable;
    private boolean isCanceled = true;
    private IExtRptMacroFilter filter;
    private ArrayList<IExtRptMacroSelectionAware> actions = new ArrayList();
    private Context context;
    private String defaultSelectedMacroUid = null;

    public SystemMacroSelectedUI(Context context, String defaultSelectedMacroUid) throws Exception {
        this.context = context;
        this.defaultSelectedMacroUid = defaultSelectedMacroUid;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(560, 510));
        this.toolBar = new KDToolBar();
        this.toolBar.add(ExtRptMacroManageActionFactory.newSearchAction(this));
        this.toolBar.add(ExtRptMacroManageActionFactory.newPreviewAction(context, this, this));
        this.putClientProperty("ShowToolBar", this.toolBar);
    }

    @Override
    public Component getComponentSelector() {
        return this;
    }

    @Override
    public Object getData() {
        DefObj def = new DefObj();
        if (this.getSelections().length == 0) {
            def.setName(QingRptLauncherMessages.getMLS("blank", ""));
            def.setAlias(QingRptLauncherMessages.getMLS("blank", ""));
        } else {
            String macroUid = this.getSelections()[0].getUid();
            def.setName(macroUid);
            def.setAlias("$" + macroUid);
            def.setProperty("tableFlag", (Object)"");
            def.setProperty(macroUid, (Object)this.getSelections()[0]);
        }
        return def;
    }

    @Override
    public int getHeightSelector() {
        return this.getPreferredSize().height;
    }

    @Override
    public KDToolBar getToolBarSelector() {
        return this.toolBar;
    }

    @Override
    public int getWidthSelector() {
        return this.getPreferredSize().width;
    }

    @Override
    public void initLayoutSelector() {
        this.macroTable = new KDTable(4, 0, 0);
        IRow headRow0 = this.macroTable.addHeadRow();
        headRow0.getCell(0).setValue((Object)QingRptLauncherMessages.getMLS("encoding", "\u7f16\u7801"));
        headRow0.getCell(1).setValue((Object)QingRptLauncherMessages.getMLS("name", "\u540d\u79f0"));
        headRow0.getCell(2).setValue((Object)QingRptLauncherMessages.getMLS("valueType", "\u503c\u7c7b\u578b"));
        headRow0.getCell(3).setValue((Object)QingRptLauncherMessages.getMLS("description", "\u63cf\u8ff0"));
        this.macroTable.getColumn(0).setWidth(130);
        this.macroTable.getColumn(1).setWidth(130);
        this.macroTable.getColumn(2).setWidth(70);
        this.macroTable.getColumn(3).setWidth(160);
        this.macroTable.setEditable(false);
        KDTSelectManager selectManager = this.macroTable.getSelectManager();
        selectManager.setSelectMode(2);
        selectManager.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                ExtMacroVO[] selections = SystemMacroSelectedUI.this.getSelections();
                for (IExtRptMacroSelectionAware action : SystemMacroSelectedUI.this.actions) {
                    action.selectionChanged(selections);
                }
                SystemMacroSelectedUI.this.defaultSelectedMacroUid = selections[0].getUid();
                SystemMacroSelectedUI.this.btnConfirm.setEnabled(selections == null ? false : selections.length > 0);
            }
        });
        this.macroTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    SystemMacroSelectedUI.this.isCanceled = false;
                    SystemMacroSelectedUI.this.close();
                }
            }
        });
        this.add((Component)this.macroTable);
        KDPanel controller = new KDPanel((LayoutManager)new BorderLayout());
        controller.add((Component)new KDLabel(" "), (Object)"North");
        controller.add((Component)new KDSeparator());
        KDPanel btnPanel = new KDPanel((LayoutManager)new FlowLayout(2, 6, 12));
        this.btnConfirm = new KDButton(QingRptLauncherMessages.getMLS("confirmBtn", "\u786e\u5b9a"));
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SystemMacroSelectedUI.this.getSelections().length == 0) {
                    MsgBox.showInfo(QingRptLauncherMessages.getMLS("pleaseSelectRecord", "\u8bf7\u9009\u62e9\u8bb0\u5f55!"));
                    return;
                }
                SystemMacroSelectedUI.this.isCanceled = false;
                SystemMacroSelectedUI.this.close();
            }
        });
        btnPanel.add((Component)this.btnConfirm);
        this.btnCancel = new KDButton(QingRptLauncherMessages.getMLS("cancelBtn", "\u53d6\u6d88"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemMacroSelectedUI.this.isCanceled = true;
                SystemMacroSelectedUI.this.close();
            }
        });
        btnPanel.add((Component)this.btnCancel);
        controller.add((Component)btnPanel, (Object)"South");
        this.add((Component)controller, "South");
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void onLoadSelector() throws Exception {
        this.loadMacros();
    }

    @Override
    public void showSelector() {
        this.filter = null;
        this.isCanceled = true;
        this.afterAction();
    }

    public void setParamMap(HashMap paramMap) {
    }

    @Override
    public void afterAction() {
        try {
            this.loadMacros();
        }
        catch (Exception e) {
            logger.error((Object)e);
            MessageUtil.msgboxWarning((Component)((Object)this), (String)e.getMessage());
        }
    }

    @Override
    public void register(IExtRptMacroSelectionAware action) {
    }

    private void loadMacros() throws Exception {
        this.macroTable.removeRows();
        int rowNum = 0;
        for (ExtMacroVO macro : MacroUtil.getAllMacros((Object)((Object)this.context))) {
            String macroUid = macro.getUid().trim();
            String macroName = macro.getName().trim();
            String macroDesc = StringUtil.isEmptyString((String)macro.getDesc()) ? null : macro.getDesc().trim();
            ExtMacroValueType macroValueType = macro.getValueType();
            if (this.filter != null) {
                boolean typeMatch = false;
                ExtMacroValueType[] selectedMacroValueTypes = this.filter.selectedMacroValueTypes();
                if (selectedMacroValueTypes != null && selectedMacroValueTypes.length > 0) {
                    for (ExtMacroValueType type : selectedMacroValueTypes) {
                        if (macroValueType != type) continue;
                        typeMatch = true;
                        break;
                    }
                }
                if (!typeMatch) continue;
                String fDesc = this.filter.description();
                String fName = this.filter.name();
                String fUid = this.filter.uid();
                boolean isUidEmpty = StringUtil.isEmptyString((String)fUid);
                boolean isNameMatch = StringUtil.isEmptyString((String)fName);
                boolean isDescMatch = StringUtil.isEmptyString((String)fDesc);
                if (!isUidEmpty && (macroUid == null || macroUid != null && macroUid.toUpperCase().indexOf(fUid.trim()) == -1) || !isNameMatch && (macroName == null || macroName != null && macroName.toUpperCase().indexOf(fName.trim()) == -1) || !isDescMatch && (macroDesc == null || macroDesc != null && macroDesc.toUpperCase().indexOf(fDesc.trim()) == -1)) continue;
            }
            IRow row = this.macroTable.addRow();
            row.setUserObject((Object)macro);
            row.getCell(0).setValue((Object)macroUid);
            row.getCell(1).setValue((Object)macroName);
            String valueType = ExtMacroValueType.SINGLE == macro.getValueType() ? QingRptLauncherMessages.getMLS("singleValue", "\u5355\u503c") : QingRptLauncherMessages.getMLS("multiValue", "\u591a\u503c");
            row.getCell(2).setValue((Object)valueType);
            row.getCell(3).setValue((Object)macroDesc);
            if (this.defaultSelectedMacroUid != null && this.defaultSelectedMacroUid.equals(macroUid)) {
                this.macroTable.getSelectManager().select(rowNum, 0);
            }
            ++rowNum;
        }
        if (this.defaultSelectedMacroUid == null) {
            this.macroTable.getSelectManager().select(0, 0);
        }
    }

    @Override
    public ExtMacroVO[] getSelections() {
        ArrayList<ExtMacroVO> ret = new ArrayList<ExtMacroVO>();
        KDTSelectManager manager = this.macroTable.getSelectManager();
        for (int i = 0; i < manager.size(); ++i) {
            KDTSelectBlock block = manager.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow() && j >= 0; ++j) {
                ret.add((ExtMacroVO)this.macroTable.getRow(j).getUserObject());
            }
        }
        return ret.toArray(new ExtMacroVO[0]);
    }

    @Override
    public void setFilter(IExtRptMacroFilter filter) {
        this.filter = filter;
    }

    private void close() {
        Window parent = SwingUtilities.getWindowAncestor(this.getComponentSelector());
        parent.setVisible(false);
        parent.dispose();
    }

    public CoreUI getCoreUI() {
        return null;
    }
}

