/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.param;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.boslayer.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.DateSettingModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DateUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.KDArrowButton;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeListener;
import com.kingdee.cosmic.ctrl.swing.util.CtrlCommonConstant;
import com.kingdee.cosmic.ctrl.swing.util.CtrlImageUtilities;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SimilarDatePicker
extends KDPanel
implements IKDEditor {
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd";
    private KDTextField kdTextField;
    private KDArrowButton kdArrowButton;
    private String pattern;
    private String value;
    private String display;
    private DateSettingModel.DateGranEnum dateGran;
    private KDPanel editor;
    private ArrowButtonHandler editorHandler;
    private JDialog popup = null;
    private WindowListener popupWindowHandler = null;
    private Action enterEscActionHandler = null;
    private Context context;
    private static final String SHORTCUT_ESC_POPUP = "esckeyforpopup";
    private int labelAlignment = 7;
    private static final int space = 1;

    public SimilarDatePicker(String value, DateSettingModel.DateGranEnum dateGran, Context ctx) {
        this.context = ctx;
        this.dateGran = dateGran;
        this.initUI();
        this.initData(value);
        this.initListener();
    }

    public SimilarDatePicker(Context ctx) {
        this.context = ctx;
        this.initUI();
        this.initListener();
    }

    public void addDataChangeListener(DataChangeListener listener) {
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDisplay() {
        return false;
    }

    public void removeDataChangeListener(DataChangeListener listener) {
    }

    public void setDisplay(boolean isDisplay) {
    }

    public void setValue(Object value) {
        this.value = (String)value;
        this.refreshDisplay();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getDisplay() {
        return this.display;
    }

    public void refreshDisplay() {
        this.setDisplay();
    }

    private void setDisplay() {
        this.setPattern();
        if (DEFAULT_PATTERN.equals(this.pattern)) {
            this.display = this.value;
        } else {
            try {
                if ("yyyy-'Q'q".equals(this.pattern)) {
                    LocalDate localDate = LocalDate.parse(this.value, DateTimeFormatter.ofPattern(DEFAULT_PATTERN));
                    this.display = localDate.format(DateTimeFormatter.ofPattern("yyyy-'Q'q"));
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_PATTERN);
                    Date date = sdf.parse(this.value);
                    sdf = new SimpleDateFormat(this.pattern);
                    this.display = sdf.format(date);
                }
            }
            catch (Exception e) {
                this.value = "";
                this.display = "";
            }
        }
        this.kdTextField.setText(this.display);
    }

    private void setPattern() {
        switch (this.dateGran) {
            case Y_M: {
                this.pattern = "yyyy-MM";
                break;
            }
            case Y_S: {
                this.pattern = "yyyy-'Q'q";
                break;
            }
            case Y: {
                this.pattern = "yyyy";
                break;
            }
            default: {
                this.pattern = DEFAULT_PATTERN;
            }
        }
    }

    public DateSettingModel.DateGranEnum getDateGran() {
        return this.dateGran;
    }

    public void setDateGran(DateSettingModel.DateGranEnum dateGran) {
        this.dateGran = dateGran;
    }

    public void setTextFieldBounds(int wOffset, int hOffset) {
        this.kdTextField.setBounds(new Rectangle(0, 0, 107 + wOffset, 19 + hOffset));
        this.kdArrowButton.setBounds(new Rectangle(108 + wOffset, -1, 19, 19 + hOffset));
    }

    private void initData(String value) {
        this.setValue(value);
    }

    private void initUI() {
        this.kdTextField = new KDTextField();
        this.kdArrowButton = new KDArrowButton(3);
        this.setLayout(null);
        this.kdTextField.setEditable(false);
        this.kdTextField.setCustomBackgroundColor(Color.white);
        this.kdTextField.setLayout(null);
        this.kdTextField.setBounds(new Rectangle(0, 0, 107, 19));
        this.kdArrowButton.setInitIcon(UIManager.getIcon("DatePicker.initIcon"));
        this.kdArrowButton.setActiveIcon(UIManager.getIcon("DatePicker.activeIcon"));
        this.kdArrowButton.setMouseOverIcon(UIManager.getIcon("DatePicker.mouseOverIcon"));
        this.kdArrowButton.setDeactiveIcon(CtrlImageUtilities.createDisableIcon((Icon)UIManager.getIcon("DatePicker.initIcon")));
        this.kdArrowButton.setLayout(null);
        this.kdArrowButton.setBounds(new Rectangle(108, 0, 19, 19));
        this.add((Component)this.kdTextField);
        this.add((Component)this.kdArrowButton);
    }

    private void initListener() {
        if (this.editorHandler == null) {
            this.editorHandler = new ArrowButtonHandler();
        }
        this.kdArrowButton.addMouseListener((MouseListener)this.editorHandler);
    }

    public void setPopupVisible(boolean v) {
        if (this.popup == null && v) {
            this.popDateEditor();
        } else if (this.popup != null) {
            boolean b = this.popup.isVisible();
            if (!b && v) {
                this.popDateEditor();
            } else if (b && !v) {
                this.popDateEditor();
            }
        }
    }

    protected void popDateEditor() {
        this.configurePopup();
        boolean b = this.popup.isVisible();
        if (!b) {
            CtrlSwingUtilities.locateWindowToComponent((Window)this.popup, null, (Component)((Object)this), (int)3);
            this.popup.show();
        } else {
            this.popup.dispose();
            this.popup = null;
        }
    }

    protected void configurePopup() {
        if (this.popup == null) {
            Window w = SwingUtilities.getWindowAncestor((Component)((Object)this));
            this.popup = w instanceof Frame ? new JDialog((Frame)w) : (w instanceof Dialog ? new JDialog((Dialog)w) : new JDialog());
            this.popup.setUndecorated(true);
            this.popup.setModal(false);
            this.popup.getContentPane().add((Component)this.editor);
            this.popup.setResizable(false);
            this.popup.pack();
            if (this.popupWindowHandler != null) {
                this.popup.removeWindowListener(this.popupWindowHandler);
                this.popupWindowHandler = null;
            }
            if (this.popupWindowHandler == null) {
                this.popupWindowHandler = new PopupWindowHandler();
                this.popup.addWindowListener(this.popupWindowHandler);
            }
            this.putEscActionToPopup(this.popup.getRootPane());
        }
    }

    private void putEscActionToPopup(JComponent comp) {
        if (this.enterEscActionHandler == null) {
            this.enterEscActionHandler = new EnterEscActionHandler();
        }
        CtrlSwingUtilities.appendActionToComponent((JComponent)comp, (int)2, (KeyStroke)CtrlCommonConstant.KEYSTROKE_ESC, (String)SHORTCUT_ESC_POPUP, (Action)this.enterEscActionHandler);
    }

    class DatePickerLayout
    implements LayoutManager {
        DatePickerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Rectangle rect = parent.getBounds();
                Dimension pDim = new Dimension(rect.width, rect.height);
                Dimension ediDim = new Dimension(SimilarDatePicker.this.editor.getWidth(), SimilarDatePicker.this.editor.getHeight());
                switch (SimilarDatePicker.this.labelAlignment) {
                    case 1: 
                    case 2: 
                    case 8: {
                        int w = ediDim.width;
                        int h = ediDim.height;
                        return new Dimension(w + 2 + 1, h + 2);
                    }
                }
                int w = ediDim.width;
                int h = ediDim.height;
                w = Math.max(w, pDim.width);
                h = Math.max(h, pDim.height);
                return new Dimension(w + 2 + 1, h + 2);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension pDim = parent.getSize();
                int w = pDim.width;
                int h = pDim.height;
                int x = 1;
                int y = 1;
                int ediW = 0;
                switch (SimilarDatePicker.this.labelAlignment) {
                    case 3: {
                        ediW = w;
                        SimilarDatePicker.this.editor.setBounds(x, y, ediW, h);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        ediW = Math.max(w, 0);
                        SimilarDatePicker.this.editor.setBounds(x, y, ediW, h);
                        break;
                    }
                    default: {
                        x = pDim.width - 1;
                        int interval = 3;
                        w = x;
                        SimilarDatePicker.this.editor.setBounds(1, y, w - 1, h - 2);
                    }
                }
            }
        }
    }

    class SimilarDateEditor
    extends KDPanel {
        private KDList yearList;
        private KDList monthOrSeasonList;
        private KDScrollPane leftPanel;
        private KDScrollPane rightPanel;
        private KDSeparator separator;
        private KDButton btnOk;
        private KDButton btnClear;
        private final Integer[] yearItems = new Integer[300];
        private final String[] monthItems = new String[]{QingRptLauncherMessages.getMLS("january", "\u4e00\u6708"), QingRptLauncherMessages.getMLS("february", "\u4e8c\u6708"), QingRptLauncherMessages.getMLS("march", "\u4e09\u6708"), QingRptLauncherMessages.getMLS("april", "\u56db\u6708"), QingRptLauncherMessages.getMLS("may", "\u4e94\u6708"), QingRptLauncherMessages.getMLS("june", "\u516d\u6708"), QingRptLauncherMessages.getMLS("july", "\u4e03\u6708"), QingRptLauncherMessages.getMLS("august", "\u516b\u6708"), QingRptLauncherMessages.getMLS("september", "\u4e5d\u6708"), QingRptLauncherMessages.getMLS("october", "\u5341\u6708"), QingRptLauncherMessages.getMLS("november", "\u5341\u4e00\u6708"), QingRptLauncherMessages.getMLS("december", "\u5341\u4e8c\u6708")};
        private String[] seasonItems;
        private KDWorkButton btnJumpTo = new KDWorkButton();
        private ResourceBundleHelper resHelper;

        public SimilarDateEditor() throws Exception {
            this.jbInit();
            this.initUIContentLayout();
            this.initData();
            this.initListener();
        }

        private void jbInit() throws Exception {
            this.resHelper = new ResourceBundleHelper(SimilarDateEditor.class.getName());
            for (int i = 1900; i <= 2199; ++i) {
                this.yearItems[i - 1900] = i;
            }
            this.yearList = new KDList((Object[])this.yearItems);
            this.yearList.setSelectionMode(0);
            this.leftPanel = new KDScrollPane((Component)this.yearList);
            this.rightPanel = new KDScrollPane();
            switch (SimilarDatePicker.this.dateGran) {
                case Y_M: {
                    this.btnJumpTo.setText(QingRptLauncherMessages.getMLS("thisMonth", "\u672c\u6708"));
                    this.monthOrSeasonList = new KDList((Object[])this.monthItems);
                    this.monthOrSeasonList.setSelectionMode(0);
                    this.rightPanel = new KDScrollPane((Component)this.monthOrSeasonList);
                    break;
                }
                case Y_S: {
                    this.btnJumpTo.setText(QingRptLauncherMessages.getMLS("thisQuarter", "\u672c\u5b63"));
                    this.seasonItems = new String[]{QingRptLauncherMessages.getMLS("seasonSeq", "\u7b2c#1\u5b63\u5ea6").replace("#1", "1"), QingRptLauncherMessages.getMLS("seasonSeq", "\u7b2c#1\u5b63\u5ea6").replace("#1", "2"), QingRptLauncherMessages.getMLS("seasonSeq", "\u7b2c#1\u5b63\u5ea6").replace("#1", "3"), QingRptLauncherMessages.getMLS("seasonSeq", "\u7b2c#1\u5b63\u5ea6").replace("#1", "4")};
                    this.monthOrSeasonList = new KDList((Object[])this.seasonItems);
                    this.monthOrSeasonList.setSelectionMode(0);
                    this.rightPanel = new KDScrollPane((Component)this.monthOrSeasonList);
                    break;
                }
                case Y: {
                    this.btnJumpTo.setText(QingRptLauncherMessages.getMLS("thisYear", "\u4eca\u5e74"));
                    break;
                }
            }
            this.separator = new KDSeparator();
            this.btnOk = new KDButton();
            this.btnClear = new KDButton();
            this.separator.setName("kDSeparator2");
            this.btnJumpTo.setName("btnJumpTo");
            this.btnOk.setName("btnOk");
            this.btnClear.setName("btnClear");
            this.btnOk.setText(QingRptLauncherMessages.getMLS("confirmBtn", "\u786e\u5b9a"));
            this.btnClear.setText(QingRptLauncherMessages.getMLS("clearBtn2", "\u6e05\u7a7a"));
        }

        public void initUIContentLayout() {
            this.setBackground(new Color(210, 227, 234));
            this.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.setBounds(new Rectangle(10, 10, 226, 235));
            this.setLayout(new DatePickerLayout());
            if (SimilarDatePicker.this.dateGran == DateSettingModel.DateGranEnum.Y) {
                this.rightPanel.setVisible(false);
                this.leftPanel.setBounds(new Rectangle(2, 2, 222, 181));
            } else {
                this.rightPanel.setVisible(true);
                this.leftPanel.setBounds(new Rectangle(2, 2, 111, 181));
            }
            this.add((Component)this.leftPanel, null);
            this.rightPanel.setBounds(new Rectangle(113, 2, 111, 181));
            this.add((Component)this.rightPanel, null);
            this.separator.setBounds(new Rectangle(1, 183, 350, 5));
            this.add((Component)this.separator, null);
            this.btnClear.setBounds(5, 198, 58, 21);
            this.add((Component)this.btnClear, null);
            this.btnJumpTo.setBounds(new Rectangle(84, 198, 58, 21));
            this.add((Component)this.btnJumpTo, null);
            this.btnOk.setBounds(new Rectangle(147, 198, 58, 21));
            this.add((Component)this.btnOk, null);
        }

        private void initData() {
            String[] valueArr = null;
            if (!StringUtil.isEmptyString((String)SimilarDatePicker.this.value)) {
                valueArr = SimilarDatePicker.this.value.split("-");
                this.yearList.setSelectedValue((Object)Integer.parseInt(valueArr[0]), true);
                switch (SimilarDatePicker.this.dateGran) {
                    case Y_M: {
                        this.monthOrSeasonList.setSelectedValue((Object)this.monthItems[Integer.parseInt(valueArr[1]) - 1], true);
                        return;
                    }
                    case Y_S: {
                        int month = Integer.parseInt(valueArr[1]);
                        int q = (month + 2) / 3;
                        this.monthOrSeasonList.setSelectedValue((Object)this.seasonItems[q - 1], true);
                        return;
                    }
                }
                return;
            }
            this.jumpToDefault();
        }

        private void initListener() {
            this.btnJumpTo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimilarDateEditor.this.jumpToDefault();
                    SimilarDateEditor.this.okActionPerformed(null);
                }
            });
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimilarDateEditor.this.okActionPerformed(null);
                }
            });
            this.btnClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimilarDateEditor.this.okActionPerformed(QingRptLauncherMessages.getMLS("blank", ""));
                }
            });
        }

        private void jumpToDefault() {
            int toSelectInd = 0;
            Date now = RunReportParam.getServerDate((Object)((Object)SimilarDatePicker.this.context));
            String formatDate = CtrlReportUtil.formatDate((Date)now);
            String[] formatDateArr = formatDate.split("-");
            int year = Integer.parseInt(formatDateArr[0]);
            this.yearList.setSelectedValue((Object)year, true);
            if (SimilarDatePicker.this.dateGran == DateSettingModel.DateGranEnum.Y_M) {
                toSelectInd = Integer.parseInt(formatDateArr[1]) - 1;
                this.monthOrSeasonList.setSelectedValue((Object)this.monthItems[toSelectInd], true);
            } else if (SimilarDatePicker.this.dateGran == DateSettingModel.DateGranEnum.Y_S) {
                int month = Integer.parseInt(formatDateArr[1]);
                toSelectInd = (month + 2) / 3 - 1;
                this.monthOrSeasonList.setSelectedValue((Object)this.seasonItems[toSelectInd], true);
            }
        }

        private void okActionPerformed(String value) {
            try {
                SimilarDatePicker.this.setValue(value != null ? value : this.editorToValue());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            SimilarDatePicker.this.refreshDisplay();
            SimilarDatePicker.this.kdTextField.setText(SimilarDatePicker.this.getDisplay());
            SimilarDatePicker.this.popup.setVisible(false);
        }

        private String editorToValue() throws ParseException {
            String ret = "";
            Integer year = Integer.valueOf(this.yearList.getSelectedValue().toString());
            switch (SimilarDatePicker.this.dateGran) {
                case Y_M: {
                    String month = String.valueOf(this.monthOrSeasonList.getSelectedIndex() + 1);
                    if (month.length() < 2) {
                        month = "0" + month;
                    }
                    ret = DateUtil.getMonthLastDay((Date)((DateFormat)CtrlReportUtil.sdf_yyyy_MM_dd.get()).parse(year + "-" + month + "-01"));
                    break;
                }
                case Y_S: {
                    int season = this.monthOrSeasonList.getSelectedIndex() + 1;
                    if (season == 1) {
                        ret = year + "-03-31";
                        break;
                    }
                    if (season == 2) {
                        ret = year + "-06-30";
                        break;
                    }
                    if (season == 3) {
                        ret = year + "-09-30";
                        break;
                    }
                    if (season != 4) break;
                    ret = year + "-12-31";
                    break;
                }
                case Y: {
                    ret = year + "-12-31";
                    break;
                }
            }
            return ret;
        }
    }

    private class PopupWindowHandler
    extends WindowAdapter {
        private PopupWindowHandler() {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            SimilarDatePicker.this.setPopupVisible(false);
        }
    }

    private class EnterEscActionHandler
    extends AbstractAction {
        private static final long serialVersionUID = 8655100269677888008L;

        private EnterEscActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            SimilarDatePicker.this.setPopupVisible(false);
        }
    }

    private class ArrowButtonHandler
    extends MouseAdapter {
        private ArrowButtonHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            try {
                if (SimilarDatePicker.this.editor == null) {
                    SimilarDatePicker.this.editor = new SimilarDateEditor();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            SimilarDatePicker.this.editor.setBounds(new Rectangle(10, 10, 226, 235));
            SimilarDatePicker.this.setPopupVisible(true);
        }
    }
}

