/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.ctrlsqldesign.param.arg.component;

import com.kingdee.bos.app.xlet.util.exception.AppFrameworkException;
import com.kingdee.bos.boslayer.bos.Context;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoExisitException;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroValue;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataSetContentNotExistsException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.MacroUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DefDbsourceModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.OrgRangeManage;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.param.ArgInputComponentFactory;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.swing.IKDTextComponent;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class KDComboBoxCreator {
    private static Logger log = LogUtil.getPackageLogger(KDComboBoxCreator.class);

    public static KDComboBox getComboBoxCtrl(Context context, DesignParameter p, String isolateTag, int runtimeType, ExecutionContext exeCtx, DesignParameter[] relatedParams) throws Exception {
        KDComboBox kDComboBox = new KDComboBox();
        IInputCtrl inputCtrl = p.getInputCtrl();
        if (null == inputCtrl) {
            return kDComboBox;
        }
        ArgInputComponentFactory.setCommonProperties((IKDTextComponent)kDComboBox, p);
        int bind = inputCtrl.getDataBind();
        if (bind == 0) {
            KDComboBoxCreator.getComboBoxCtrl_INTDB(context, kDComboBox, inputCtrl, isolateTag, exeCtx, relatedParams);
        } else if (bind == 6) {
            KDComboBoxCreator.getComboBoxCtrl_INTSYSTEM(context, kDComboBox, inputCtrl, exeCtx);
        } else if (bind == 7) {
            ExtMacroValue extMacroValue;
            String macroUid = inputCtrl.getDefDbsource().getName();
            String ctrlDefDisplay = inputCtrl.getDefDisplay().getName();
            String ctrlDefValue = inputCtrl.getDefValue().getName();
            try {
                ArrayList<String> fieldNames = new ArrayList<String>(2);
                fieldNames.add(ctrlDefValue);
                fieldNames.add(ctrlDefDisplay);
                extMacroValue = MacroUtil.loadMacroValuesByFieldNames((Object)((Object)context), (String)macroUid, fieldNames, (int)-1);
            }
            catch (ExtMacroException e) {
                log.error((Object)("-------failed to execute macro" + macroUid + "----------"), (Throwable)e);
                throw e;
            }
            List allColumnValues = extMacroValue.getAllColumnValues();
            List allColumnNames = extMacroValue.getAllColumnNames();
            int defValueIndex = -1;
            int defDisplayIndex = -1;
            int len = allColumnNames.size();
            for (int j = 0; j < len; ++j) {
                String columnName = (String)allColumnNames.get(j);
                if (ctrlDefValue.equalsIgnoreCase(columnName)) {
                    defValueIndex = j;
                }
                if (ctrlDefDisplay.equalsIgnoreCase(columnName)) {
                    defDisplayIndex = j;
                }
                if (defValueIndex != -1 && defDisplayIndex != -1) break;
            }
            if (defDisplayIndex == -1) {
                throw ExtMacroException.newNonFieldMacroException((String)extMacroValue.getMacroUid(), (String)ctrlDefDisplay);
            }
            if (defValueIndex == -1) {
                throw ExtMacroException.newNonFieldMacroException((String)extMacroValue.getMacroUid(), (String)ctrlDefValue);
            }
            ArrayList<DefObj> itemDatas = new ArrayList<DefObj>();
            if (allColumnValues != null && allColumnValues.size() > 0) {
                int rowCount = ((List)allColumnValues.get(0)).size();
                for (int i = 0; i < rowCount; ++i) {
                    DefObj o = new DefObj();
                    o.setName(CtrlReportUtil.getObjectString(((List)allColumnValues.get(defValueIndex)).get(i)));
                    o.setAlias(CtrlReportUtil.getObjectString(((List)allColumnValues.get(defDisplayIndex)).get(i)));
                    itemDatas.add(o);
                }
            }
            KDComboBoxCreator.buildComboBox(kDComboBox, itemDatas.iterator(), ctrlDefValue, ctrlDefDisplay);
        } else if (bind == 1) {
            Iterator itemDataIter = inputCtrl.getSelfList().iterator();
            KDComboBoxCreator.buildComboBox(kDComboBox, itemDataIter, null, null);
        }
        if (p.getDefaultValue() != null) {
            int size = kDComboBox.getItemCount();
            String defaultValue = p.getDefaultValue();
            if (!"#@$firstData$@#".equals(defaultValue)) {
                String[] stringArray;
                if ((defaultValue = ArgInputComponentFactory.pertreateParameter(context, defaultValue, runtimeType)) == null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                } else {
                    stringArray = defaultValue.split("0xx1xx");
                }
                String[] values = stringArray;
                boolean contain = false;
                for (int i = 0; i < size; ++i) {
                    DefObj defObj = (DefObj)kDComboBox.getItemAt(i);
                    if (!defObj.getName().equals(values[0])) continue;
                    contain = true;
                    kDComboBox.setSelectedItem((Object)defObj);
                    break;
                }
                if (!contain && inputCtrl.isAllowEdit()) {
                    DefObj def = new DefObj();
                    def.setAlias(values[0]);
                    def.setName(values[0]);
                    kDComboBox.setSelectedItem((Object)def);
                }
            } else if (size > 1) {
                kDComboBox.setSelectedIndex(1);
            }
        }
        return kDComboBox;
    }

    private static final void getComboBoxCtrl_INTSYSTEM(Context context, KDComboBox kDComboBox, IInputCtrl inputCtrl, ExecutionContext exeCtx) {
        List lst = OrgRangeManage.getOrgRangeList((Object)((Object)context));
        if (lst == null || lst.isEmpty()) {
            return;
        }
        String displayKey = inputCtrl.getDefDisplay().getName();
        String valueKey = inputCtrl.getDefValue().getName();
        Iterator itemDataIter = lst.iterator();
        KDComboBoxCreator.buildComboBox(kDComboBox, itemDataIter, valueKey.toLowerCase(), displayKey.toLowerCase());
    }

    private static final void getComboBoxCtrl_INTDB(Context context, KDComboBox kDComboBox, IInputCtrl inputCtrl, String isolateTag, ExecutionContext exeCtx, DesignParameter[] relatedParams) throws Exception {
        String displayKey = "alias";
        String valueKey = "value";
        String dataSetType = inputCtrl.getDataSetType();
        boolean isKSQL = !"6".equals(dataSetType);
        DefObj def = inputCtrl.getDefDbsource();
        DefDbsourceModel defDbsourceModel = new DefDbsourceModel(def);
        String dbsourceName = defDbsourceModel.getName();
        if (isKSQL) {
            displayKey = inputCtrl.getDefDisplay().getName();
            valueKey = inputCtrl.getDefValue().getName();
        }
        HashMap<String, String> models = null;
        if (null != exeCtx) {
            models = new HashMap<String, String>();
            String groupID = defDbsourceModel.getGroupID();
            String cacheKey = SqlDSModelDrill.getKey((String)dbsourceName, (String)groupID);
            String embedMetaData = (String)exeCtx.getDataSetCacheObject((Object)cacheKey);
            models.put(cacheKey, embedMetaData);
        }
        Iterator itemDataIter = null;
        try {
            itemDataIter = RunReportParam.getBizDataList((Object)((Object)context), (boolean)isKSQL, (DefObj)def, models, (DesignParameter[])relatedParams).iterator();
        }
        catch (ExtDataSetNoExisitException e) {
            throw e;
        }
        catch (ExtDataSetNoPermissionException e) {
            throw e;
        }
        catch (DataCenterNoPermissionException e) {
            throw e;
        }
        catch (DataSetContentNotExistsException e) {
            throw e;
        }
        catch (AppFrameworkException e) {
            if (e.getCause() instanceof ExtMacroException) {
                throw e;
            }
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        KDComboBoxCreator.buildComboBox(kDComboBox, itemDataIter, valueKey.toLowerCase(), displayKey.toLowerCase());
    }

    private static void buildComboBox(KDComboBox kDComboBox, Iterator itemDataIter, String valueKey, String displayKey) {
        String defName = "";
        String defAlias = "";
        ArrayList<DefObj> items = new ArrayList<DefObj>(16);
        if (itemDataIter.hasNext()) {
            items.add(KDComboBoxCreator.constructItem(defName, defAlias));
        }
        while (itemDataIter.hasNext()) {
            DefObj item;
            Object dataItem = itemDataIter.next();
            DefObj defObj = item = dataItem instanceof DefObj ? (DefObj)dataItem : null;
            if (null == item && !StringUtils.isEmpty((CharSequence)valueKey)) {
                Map mapItem = (Map)dataItem;
                defName = CtrlReportUtil.getObjectString(mapItem.get(valueKey));
                defAlias = CtrlReportUtil.getObjectString(mapItem.get(displayKey));
                item = KDComboBoxCreator.constructItem(defName, defAlias);
            }
            if (null == item) continue;
            items.add(item);
        }
        kDComboBox.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
    }

    private static DefObj constructItem(String name, String alias) {
        DefObj item = new DefObj();
        item.setName(name);
        item.setAlias(alias);
        return item;
    }
}

