/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.edd.tabkid;

import com.kingdee.bos.app.launcher.i18n.QingRptLauncherMessages;
import com.kingdee.bos.datawizard.common.tabframework.AbstractTabkidWrapper;
import com.kingdee.bos.datawizard.common.tabframework.ITabkidChangeListener;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.datawizard.edd.ctrlreport.util.MessageUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.DesignUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.OutputFieldsUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.client.PreviewKSQLPanelUI;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.SuperQueryNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.datawizard.edd.model.EDDContextBetweenTabkids;
import com.kingdee.bos.extreport.utils.CloseUtil;
import com.kingdee.cosmic.ctrl.data.modal.IDefObj;
import com.kingdee.cosmic.ctrl.data.modal.Outputs;
import com.kingdee.cosmic.ctrl.data.modal.query.Column;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.cosmic.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class OutputFieldsUITabkidWrapper
extends AbstractTabkidWrapper {
    private static Logger logger = Logger.getLogger(OutputFieldsUITabkidWrapper.class);
    private String title = QingRptLauncherMessages.getMLS("outputFieldPanel", "\u8f93\u51fa\u5b57\u6bb5");
    private OutputFieldsUI outputFieldsUI = new OutputFieldsUI(((EDDContextBetweenTabkids)this.getContext()).getDesignUI());
    private ITabkidChangeListener listener;
    private boolean hasIntoThisTabkid = false;
    private Exception verifyException = null;

    public OutputFieldsUITabkidWrapper(EDDContextBetweenTabkids ctx) {
        super(ctx);
    }

    @Override
    protected String getTitle() {
        return this.title;
    }

    @Override
    protected void initUI(KDPanel ui) {
        ui.setCustomInsets(new Insets(8, 8, 8, 8));
        ui.setLayout((LayoutManager)new BorderLayout());
        ui.add((Component)this.outputFieldsUI.getPanel());
    }

    @Override
    protected void initTabkidChangeListener() {
        if (this.listener == null) {
            this.listener = new ITabkidChangeListener(){

                @Override
                public void tabkidChange(String eventKey) {
                    EDDContextBetweenTabkids ctx = (EDDContextBetweenTabkids)OutputFieldsUITabkidWrapper.this.getContext();
                    if ("OutDBUIChanged".equals(eventKey) || "ParamUIChanged".equals(eventKey) || "SqlUIChanged".equals(eventKey)) {
                        ctx.setNeedRefresh(true);
                    }
                }
            };
            this.addListener("OutDBUIChanged", this.listener);
            this.addListener("ParamUIChanged", this.listener);
            this.addListener("SqlUIChanged", this.listener);
        }
    }

    @Override
    protected void intoThisTabkid() {
        this.hasIntoThisTabkid = true;
        this.outputFieldsUI.syncModel2Ui();
    }

    @Override
    protected void outThisTabkid() {
        this.outputFieldsUI.syncUi2Model();
        this.fireEvent("OutputFieldsUIChanged");
    }

    @Override
    protected String verify() {
        if (this.hasIntoThisTabkid) {
            this.outputFieldsUI.syncUi2Model();
        }
        this.fireEvent("OutputFieldsUIChanged");
        EDDContextBetweenTabkids ctx = (EDDContextBetweenTabkids)this.getContext();
        this.verifyException = null;
        if (!ctx.isPreviewing()) {
            try {
                this.setOutputColumns(((EDDContextBetweenTabkids)this.getContext()).getDesignUI(), ((EDDContextBetweenTabkids)this.getContext()).isPreviewing());
                this.outputFieldsUI.syncModel2Ui();
            }
            catch (CtrlReportException e) {
                this.outputFieldsUI.syncUi2Model();
                this.verifyException = e;
                return null;
            }
            this.outputFieldsUI.syncUi2Model();
        }
        return null;
    }

    @Override
    public Exception hasVerifyException() {
        return this.verifyException;
    }

    public final void setOutputColumns(DesignUI designUI, boolean isSave) throws CtrlReportException {
        String keyName;
        Column sqlColumn;
        int n;
        CtrlDesignQueryModel model = designUI.getModel();
        Map<String, Column> oldNameAlisaMap = OutputFieldsUI.getNameAlisaMapFromModel(model);
        IQuery quer = model.getQuery();
        OutputColumns newOutputColumns = new OutputColumns();
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)quer;
        OutputColumns sqlOutputColumns = null;
        ResultSet rs = null;
        try {
            Map mapDesignParam = RunReportParam.getParamDefalutValue((Object)((Object)designUI.getContext()), (CtrlDesignQueryModel)model);
            Iterator it = mapDesignParam.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next().toString();
                DesignParameter p = (DesignParameter)mapDesignParam.get(name);
                if (name.startsWith("ExtRpt")) continue;
                p.setDefaultValue(QingRptLauncherMessages.getMLS("blank", ""));
            }
            rs = CtrlDesignDataExecutor.preview((Object)((Object)designUI.getContext()), (CtrlDesignQueryModel)model, (Map)mapDesignParam, null);
            sqlOutputColumns = PreviewKSQLPanelUI.parseRSMD(rs.getMetaData());
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                ksqlQuery.setGoodOutput("false");
                String msg = QingRptLauncherMessages.getMLS("dataSetExecutionFailed", "\u6267\u884c\u6570\u636e\u96c6\u5931\u8d25\uff0c\u65e0\u6cd5\u5237\u65b0\u8f93\u51fa\u5b57\u6bb5\uff0c\u5c06\u65e0\u6cd5\u5728\u8f7b\u62a5\u8868\u4e2d\u4f7f\u7528\u8be5\u6570\u636e\u96c6\uff01");
                if (e instanceof SuperQueryNoPermissionException) {
                    msg = e.getMessage();
                } else if (e instanceof ExtMacroException) {
                    msg = ((ExtMacroException)((Object)e)).getErrorMessage();
                }
                throw CtrlReportException.makeException((String)msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close(rs);
                throw throwable;
            }
        }
        CloseUtil.close((ResultSet)rs);
        HashSet<String> mapRepeatName = new HashSet<String>();
        for (n = 0; n < sqlOutputColumns.size(); ++n) {
            sqlColumn = (Column)sqlOutputColumns.get(n);
            keyName = sqlColumn.getName().toUpperCase();
            if (mapRepeatName.contains(keyName)) {
                String msg = QingRptLauncherMessages.getMLS("failGenerateOutputField", "\u751f\u6210\u8f93\u51fa\u5b57\u6bb5\u5931\u8d25\uff0cSELECT\u8bed\u53e5\u6709\u91cd\u590d\u7684\u5217\u540d\uff08#1\uff09\uff0c\u8bf7\u91cd\u65b0\u8bbe\u8ba1SQL\u8bed\u53e5").replace("#1", keyName);
                if (isSave) {
                    msg = QingRptLauncherMessages.getMLS("saveSucess", "\u4fdd\u5b58\u6210\u529f\uff0c\u4f46") + msg;
                }
                MessageUtil.showInfo(msg, false, "");
                ksqlQuery.setGoodOutput("false");
                return;
            }
            mapRepeatName.add(keyName);
        }
        ksqlQuery.setGoodOutput("true");
        for (n = 0; n < sqlOutputColumns.size(); ++n) {
            sqlColumn = (Column)sqlOutputColumns.get(n);
            keyName = sqlColumn.getName().toUpperCase();
            Column newColumn = new Column();
            if (oldNameAlisaMap.containsKey(keyName)) {
                newColumn.copy((IDefObj)oldNameAlisaMap.get(keyName));
            } else {
                newColumn.copy((IDefObj)sqlColumn);
            }
            newColumn.setDataType(sqlColumn.getDataType());
            newOutputColumns.add(newColumn);
        }
        oldNameAlisaMap.clear();
        sqlOutputColumns.clear();
        Outputs outputs = model.getCommonQuery().getOutputs();
        if (outputs == null) {
            outputs = new Outputs();
            model.getCommonQuery().setOutputs(outputs);
        }
        outputs.clear();
        outputs.add((Object)newOutputColumns);
    }
}

